% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DOEM2.R
\name{DOEM2}
\alias{DOEM2}
\title{The DOEM2 algorithm is an online EM algorithm in distributed manner, which is used to solve the parameter estimation of multivariate Gaussian mixture model.}
\usage{
DOEM2(y, M, seed, alpha0, mu0, sigma0, a, b)
}
\arguments{
\item{y}{is a data matrix}

\item{M}{is the number of subsets}

\item{seed}{is the recommended way to specify seeds}

\item{alpha0}{is the initial value of the mixing weight}

\item{mu0}{is the initial value of the mean}

\item{sigma0}{is the initial value of the covariance}

\item{a}{represents the power of the reciprocal of the step size}

\item{b}{indicates that the M-step is not implemented for the first b data points}
}
\value{
DOEM2alpha,DOEM2mu,DOEM2sigma,DOEM2time
}
\description{
The DOEM2 algorithm is an online EM algorithm in distributed manner, which is used to solve the parameter estimation of multivariate Gaussian mixture model.
}
\examples{
library(mvtnorm)
alpha1= c(rep(1/4,4)) 
mu1=matrix(0,nrow=4,ncol=4) 
for (k in 1:4){
mu1[4,]=c(runif(4,(k-1)*3,k*3)) 
}
sigma1=list()
for (k in 1:4){
sigma1[[k]]= diag(4)*0.1
}
y= matrix(0,nrow=200,ncol=4) 
for(k in 1:4){
y[c(((k-1)*200/4+1):(k*200/4)),] = rmvnorm(200/4,mu1[k,],sigma1[[k]]) 
}
M=2
seed=123
alpha0= alpha1
mu0=mu1
sigma0=sigma1
a=1
b=10
DOEM2(y,M,seed,alpha0,mu0,sigma0,a,b)
}
