% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DELTD.R
\name{mse}
\alias{mse}
\title{Calculate Mean Squared Error(MSE) by using different Kernels}
\usage{
mse(kernel, type)
}
\arguments{
\item{kernel}{type of kernel which is to be used}

\item{type}{mention distribution of vector. If exponential distribution then use \code{"Exp"}.
If use gamma distribution then use \code{"Gamma"}.If Weibull distribution then use \code{"Weibull"}.}
}
\value{
Mean Squared Error (MSE)
}
\description{
This function calculates the mean squared error (MSE) by using user specified kernel. But distribution of vector should be Exponential, Gamma or Weibull. Any other choice of distribution will result \code{NaN}.
}
\examples{
y <- rexp(100, 1)
xx <- seq(min(y) + 0.05, max(y), length = 500)
h <- 2
gr <- Gamma(x = xx, y = y, k = 200, h = h)
mse(kernel = gr, type = "Exp")
## if distribution is other than mentioned \\code{type} is used then NaN will be produced.
\dontrun{
mse(kernel = gr, type ="Beta")
}
}
\references{
\itemize{
\item Jin, X.; Kawczak, J. 2003. Birnbaum-Saunders & Lognormal kernel estimators for modeling durations in high frequency financial data. \emph{Annals of Economics and Finance} \strong{4}, 103-124.
\item Salha, R. B.; Ahmed, E. S.; Alhoubi, I. M. 2014. Hazard rate function estimation using Erlang Kernel. \emph{Pure Mathematical Sciences} \strong{3} (4), 141-152.
\item Chen, S. X. 2000. Probability density function estimation using Gamma kernels. \emph{Annals of the Institute of Statistical Mathematics} \strong{52} (3), 471-480.
\item Chen, S. X. 2000. Beta kernel smothers for regression curves. \emph{Statistica Sinica} \strong{10}, 73-91.
}
}
\author{
Javaria Ahmad Khan, Atif Akbar.
}
