% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DELTD.R
\name{plot.Beta}
\alias{plot.Beta}
\title{Density Plot by Beta kernel}
\usage{
\method{plot}{Beta}(x, ...)
}
\arguments{
\item{x}{an object of class "Beta"}

\item{\dots}{Not presently used in this implementation}
}
\value{
nothing
}
\description{
Plot density by using Beta Kernel.
}
\examples{
y <- runif(100)
h <- 0.5
xx <- sample(0.00001:900, 50, replace = FALSE)/1000
den <- Beta(x = xx, y = y, k = 50, h = h)
plot(den, type = "p")
##other details can also be added
y <- runif(100)
h <- 0.7
xx <- sample(0.00001:900, 50, replace = FALSE)/1000
den <- Beta(x = xx, y = y, k = 50, h = h)
plot(den, type = "l", ylab = "Density Function", lty = 1, xlab = "Time")

}
\references{
Chen, S. X. 2000. Beta kernel smothers for regression curves. \emph{Statistica Sinica} \strong{10}, 73-91.
}
\seealso{
For further kernels see \code{\link{plot.Gamma}}, \code{\link{plot.Erlang}}, \code{\link{plot.BS}} and \code{\link{plot.LogN}}. To calculate its estimated values see \code{\link{Beta}} and for
MSE see \code{\link{mse}}.
}
\author{
Javaria Ahmad Khan, Atif Akbar.
}
