% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcem_init_uv.R
\name{means_uv}
\alias{means_uv}
\title{means_uv: Part of DCEM package.}
\usage{
means_uv(data, num_means)
}
\arguments{
\item{data}{(matrix): The dataset provided by the user (converted to matrix format).}

\item{num_means}{(number): The number of means (meu).}
}
\value{
A vector containing the randomly selected samples from the dataset.
The initial means will be updated during the execution.
}
\description{
This function is internally called by the dcem_train to initialize the
mean(s) for the Gaussian(s). It randomly selects the mean(s) from the
range min(data):max(data).
}
\examples{
# Randomly selecting the samples from a normal distribution as inital mean(s).

means_uv(rnorm(100,20,10), 2)

}
\author{
Parichit Sharma \email{parishar@iu.edu}, Hasan Kurban, Mark Jenne, Mehmet Dalkilic

This work is partially supported by NCI Grant 1R01CA213466-01.
}
