% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sim_power_indiv.R
\name{sim_stats_mef}
\alias{sim_stats_mef}
\title{sim_power_indiv.R}
\usage{
sim_stats_mef(
  B,
  sigSq,
  xMat,
  gMat,
  alphaVec,
  betaVec,
  decompTrue = NULL,
  checkpoint = FALSE
)
}
\arguments{
\item{B}{Number of simulations.}

\item{sigSq}{Variance of outcome.}

\item{xMat}{Design matrix of non-genetic covariates, n*p.}

\item{gMat}{Matrix of genotypes, n*J.}

\item{alphaVec}{p*1 vector of regression coefficients for xMat.}

\item{betaVec}{J*1 vector of regression coefficients for gMat.}

\item{decompTrue}{The return value of a call to eigen() on the true covariance matrix. Can be null,
in which case estimated covariance will be used.}

\item{checkpoint}{Boolean, if true then print message every 50 simulations.}
}
\value{
A list with the elements:
\item{zMat}{B*J matrix of test statistics Z.}
\item{zVecGBJ}{Check on Z statistics, vector should match first row of zMat.}
\item{iMat}{Innovated statistics matrix also of dimension B*J.}
}
\description{
Simulate power starting from individual-level data for multiple
explanatory factor setting.
}
\examples{
\donttest{
xMat <- cbind(1, rnorm(n = 1000), rbinom(n = 1000, size=1, prob=0.5))
gMat <- matrix(data = rbinom(n=10000, size=2, prob=0.3), nrow=1000)
alphaVec <- c(1, 1, 1)
betaVec <- rep(0, 10)
sim_stats_mef(B=10000, sigSq = 1, xMat = xMat, gMat = gMat, alphaVec = alphaVec, betaVec = betaVec)
}
}
