% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DBERlibR.R
\name{one_way_repeated_anova}
\alias{one_way_repeated_anova}
\title{One-way Repeated Measures ANOVA}
\usage{
one_way_repeated_anova(
  treat_pre_csv_data,
  treat_post_csv_data,
  treat_post2_csv_data,
  m_cutoff = 0.15
)
}
\arguments{
\item{treat_pre_csv_data}{This function requires a csv file with treatment
group's pre-test data. Its name (e.g., "data_treat_pre.csv") can be passed
as an argument. Make sure to set the folder with the data file(s) as the
working directory.}

\item{treat_post_csv_data}{This function requires a csv file with treatment
group's post-test data. Its name (e.g., "data_treat_post.csv") can be passed
as an argument. Make sure to set the folder with the data file(s) as the
working directory.}

\item{treat_post2_csv_data}{This function requires a csv file with treatment
group's post2-test. Its name (e.g., "data_treat_post2.csv") can be passed as
an argument. Make sure to set the folder with the data file(s) as the working
directory.}

\item{m_cutoff}{This package will treat skipped answers as incorrect.
However, too many skipped answers may skew the results of the data analysis.
User can can provide a cutoff for the proportion of skipped answers.
For example, if the user enters 0.1, students who skipped more than
10 percent of the answers will be excluded from the data analysis to prevent
skewed results. The default of 0.15 is commonly applied as a rule of thumb.}
}
\value{
This function returns a \code{tibble()} including the following
information:
\itemize{
 \item \code{n_students_deleted}: Number of students deleted from the data
 for analysis based on the percentage obtained via the argument of m_cutoff
 \item \code{descriptive_statistics}: Descriptive statistics
 \item \code{boxplots}: Boxplots - visual presentation of the descriptive
 statistics
 \item \code{shapiro_wilk_test}: Shapiro-Wilk test results to determine
 normality of residuals
 \item \code{normal_qq_plot}: The normal q-q plot to visually inspect the
 normality of residuals
 \item \code{one_way_repeated_anova}: Results of the one-way repeated
 measures ANOVA
 \item \code{one_way_repeated_anova_pwc}: Pairwise t-test results for the
 one-way repeated measures ANOVA
 \item \code{friedman_test}: Results of the friedman test
 \item \code{friedman_pwc}: Pairwise t-test results for the Friedman test
}
}
\description{
This function automatically merges pre, post, and post2 datasets,
and then runs the one-way repeated measures ANOVA with assumptions check
all at once. Please make sure to name data files accurately (i.e.,
“data_treat_pre.csv”, “data_treat_post.csv”, and “data_treat_post2.csv”)
and have them saved in the working directory.
}
\examples{
# Run the following codes directly in the console panel. The plots
# generated through the link above may be displaced depending on the screen
# resolution.
one_way_repeated_anova(treat_pre_csv_data =
       system.file("extdata", "data_treat_pre.csv", package = "DBERlibR"),
       treat_post_csv_data =
       system.file("extdata", "data_treat_post.csv", package = "DBERlibR"),
       treat_post2_csv_data =
       system.file("extdata", "data_treat_post2.csv", package = "DBERlibR"),
       m_cutoff = 0.15)

}
