% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAMisc_functions.R
\name{xt}
\alias{xt}
\alias{xt.data.frame}
\alias{xt.survey.design}
\alias{print.xt}
\title{Cross-Tabulation of Weighted or Unweighted Data}
\usage{
xt(data, var, byvar = NULL, controlvar = NULL, weight = NULL, ...)
}
\arguments{
\item{data}{Either a data frame or a survey design object.}

\item{var}{Row variable for the cross-tabular.}

\item{byvar}{Optional column variable for the cross-tabulation.  If \code{NULL}, a frequency and relative frequency distribution of \code{var} will be produced.}

\item{controlvar}{The name of a categorical control variable.}

\item{weight}{A vector of weights to be applied to the table.}

\item{...}{Other arguments to be passed down to \code{make_assoc_stats}.  You can use this to calculate different statistics.  By default, you get Chi-squared, Cramer's V, Gamma and Kendall's Tau-b. 

Produces a cross-tabulation and Chi-square statistic for weighted or unweighted data.}
}
\value{
A list with two elements - table of class \code{tabyl} and the returned results from \code{svychisq}.
}
\description{
Cross-Tabulation of Weighted or Unweighted Data
}
