% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_shap_aggregated.R
\name{plot.shap_aggregated}
\alias{plot.shap_aggregated}
\title{Plot Generic for Break Down Objects}
\usage{
\method{plot}{shap_aggregated}(
  x,
  ...,
  shift_contributions = 0.05,
  add_contributions = TRUE,
  add_boxplots = TRUE,
  max_features = 10,
  title = "Aggregated SHAP"
)
}
\arguments{
\item{x}{an explanation object created with function \code{\link[DALEX]{explain}}.}

\item{...}{other parameters like \code{vcolors}, \code{vnames}, \code{min_max}, \code{digits}, \code{rounding_function}, \code{baseline}, \code{subtitle}, \code{baseline}, \code{max_vars}.}

\item{shift_contributions}{number describing how much labels should be shifted to the right, as a fraction of range. By default equal to \code{0.05}.}

\item{add_contributions}{if \code{TRUE}, variable contributions will be added to the plot}

\item{add_boxplots}{if \code{TRUE}, boxplots of SHAP will be shown}

\item{max_features}{maximal number of features to be included in the plot. default value is \code{10}.}

\item{title}{a character. Plot title. By default \code{"Break Down profile"}.}
}
\value{
a \code{ggplot2} object.
}
\description{
Displays a waterfall aggregated shap plot for objects of \code{shap_aggregated} class.
}
\examples{
library("DALEX")
set.seed(1313)
model_titanic_glm <- glm(survived ~ gender + age + fare,
                       data = titanic_imputed, family = "binomial")
explain_titanic_glm <- explain(model_titanic_glm,
                           data = titanic_imputed,
                           y = titanic_imputed$survived,
                           label = "glm")

\donttest{
bd_glm <- shap_aggregated(explain_titanic_glm, titanic_imputed[1:10, ])
bd_glm
plot(bd_glm)
plot(bd_glm, max_features = 3)
plot(bd_glm, max_features = 3,
     vnames = c("average","+ male","+ young","+ cheap ticket", "+ other factors", "final"))
}

}
