% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/misc_loss_functions.R
\name{loss_yardstick}
\alias{loss_yardstick}
\title{Wrapper for Loss Functions from the Yarstick Package}
\usage{
loss_yardstick(loss)
}
\arguments{
\item{loss}{loss function from the yardstick package}
}
\value{
loss function that can be used in the model_parts function
}
\description{
The yardstick package provides many auxiliary functions for calculating
the predictive performance of the model. However, they have an interface
that is consistent with the tidyverse philosophy. The loss_yardstick
function adapts loss functions from the yardstick package to functions
understood by DALEX. Type compatibility for y-values and for predictions
must be guaranteed by the user.
}
\examples{
 \donttest{
 # Classification Metrics
 # y and y_hat are factors!!!
 library("yardstick")

 titanic_glm_model <- glm(survived~., data = titanic_imputed, family = "binomial")
 explainer_glm <- DALEX::explain(titanic_glm_model,
                                 data = titanic_imputed[,-8],
                                 y = factor(titanic_imputed$survived),
                                 predict_function = function(m, x) {
                                   factor((predict(m, x, type = "response") > 0.5) + 0)
                                 })

model_parts_accuracy <- model_parts(explainer_glm, type = "raw",
                             loss_function = loss_yardstick(accuracy))
plot(model_parts_accuracy)

# Class Probability Metrics
# y is a factor while y_hat is a numeric!!!

 titanic_glm_model <- glm(survived~., data = titanic_imputed, family = "binomial")
 explainer_glm <- DALEX::explain(titanic_glm_model,
                                 data = titanic_imputed[,-8],
                                 y = factor(titanic_imputed$survived))

model_parts_accuracy <- model_parts(explainer_glm, type = "raw",
                             loss_function = loss_yardstick(roc_auc))
plot(model_parts_accuracy)

# Regression Metrics
# y and y_hat are numeric!!!

library("ranger")
apartments_ranger <- ranger(m2.price~., data = apartments, num.trees = 50)
explainer_ranger  <- DALEX::explain(apartments_ranger, data = apartments[,-1],
                                    y = apartments$m2.price, label = "Ranger Apartments")
model_parts_ranger <- model_parts(explainer_ranger, type = "raw",
                       loss_function = loss_yardstick(rsq))
plot(model_parts_ranger)

}

}
