% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rm_duplicate_island_species.R
\name{rm_duplicate_island_species}
\alias{rm_duplicate_island_species}
\title{Remove any duplicated species from the \code{island_tbl} after \code{"asr"} extraction}
\usage{
rm_duplicate_island_species(
  island_tbl,
  phylod,
  nested_asr_species,
  include_not_present
)
}
\arguments{
\item{island_tbl}{An instance of the \code{Island_tbl} class.}

\item{phylod}{A \code{phylo4d} object from the package \code{phylobase} containing
phylogenetic and endemicity data for each species.}

\item{nested_asr_species}{A \code{character} string which determines whether
\emph{nested island colonists} are split into separate colonists (\code{"split"}), or
grouped into a single clade (\code{"group"}). Nested species are those whose tip
state is on the island, and they have ancestral nodes on the island, but
there are nodes in between these island state nodes that have the state
\code{not_present} (i.e. not on the island). Therefore, the colonisation time
can be extracted as the most recent node state on the island (this can be
the branching time before the tip if the ancestor node of the tip is not
on the island), or the older node state of the larger clade, for \code{"split"}
or \code{"group"} respectively. \strong{Note} This argument only applies when
\code{extraction_method = "asr"}.}

\item{include_not_present}{A boolean determining whether species not present
on the island should be included in island colonist when embedded within an
island clade. Default is FALSE.}
}
\value{
An object of \code{Island_tbl} class
}
\description{
Removes any duplicates species from the \code{island_tbl} by choosing to either
have duplicated species be in smaller, more recently colonised clade(s) and
removing them from the larger, older clade(s)
(\code{nested_asr_species = "split"}), or removing the smaller, more recently
colonised clade(s) in favour of leaving them in the larger, older clade(s)
(\code{nested_asr_species = "group"}).
}
\keyword{internal}
