% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DAISIE_utils.R
\name{translate_island_ontogeny}
\alias{translate_island_ontogeny}
\title{Translate user-friendly ontogeny codes to numerics}
\usage{
translate_island_ontogeny(island_ontogeny)
}
\arguments{
\item{island_ontogeny}{In \code{\link{DAISIE_sim_time_dep}()},
\code{\link{DAISIE_ML_CS}} and plotting a string describing the type of
island ontogeny. Can be \code{"const"}, \code{"beta"} for a beta function
describing area through time. String checked by
\code{\link{is_island_ontogeny_input}()}. \cr In all other functions a
numeric describing the type of island ontogeny. Can be \code{0} for
constant, \code{1} for a beta function describing area through time. In ML
functions \code{island_ontogeny = NA} assumes constant ontogeny. Time
dependent estimation is not yet available as development is still ongoing.
Will return an error if called in that case.}
}
\value{
Numeric, 0 for null-ontogeny, 1 for beta function
}
\description{
Translate user-friendly ontogeny codes to numerics
}
\examples{
translated_ontogeny <- DAISIE:::translate_island_ontogeny("const")
}
\keyword{internal}
