% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/top_D3M.R
\name{topD3M}
\alias{topD3M}
\title{Subsetting Top Significant Distribution Pairs and Output Graphics.}
\usage{
topD3M(obj, ntop = 10, plot.it = TRUE)
}
\arguments{
\item{obj}{D3M object resulted from d3m.}

\item{ntop}{the number of top distribution pairs to be investigated. Default is 10.}

\item{plot.it}{whether output the grphics based on Q-Q plot. Defarult is plot.it=TRUE.}
}
\value{
top.cases top significant distributions in case group.

top.control top significant distributions in control group.

pval p-values related to top significant distribution pairs.

Q-Q plots of distribution pairs.
}
\description{
Subsetting Top Significant Distribution Pairs and Output Graphics.
}
\details{
this function extract a subset of the most significant distribution pairs based on p-values. The graphical representation is based on Q-Q plots, which represents the shape difference being tested by d3m function.
}
\examples{
library(D3M)
nrep <- 12
cases <- Map(rbeta,rep(100,nrep),rep(1,nrep),rep(5,nrep)); cases <- do.call("rbind",cases)
control <- Map(rbeta,rep(100,nrep),rep(1,nrep),rep(5,nrep)); control <- do.call("rbind",control)
obj <- d3m(cases,control,paranum = 101, q = 2, bsn = 5000)
topD3M(obj,ntop = 10,plot.it = TRUE)
}
\author{
Yusuke Matsui & Teppei Shimamura
}

