% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.ClusterPredictions.R
\name{ClusterPredictions}
\alias{ClusterPredictions}
\title{Manages the predictions achieved on a cluster.}
\description{
Stores the predictions achieved by the best M.L. of each cluster.
}
\seealso{
\code{\link{D2MCS}}, \code{\link{ClassificationOutput}},
\code{\link{Prediction}}
}
\keyword{math}
\keyword{methods}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-ClusterPredictions-new}{\code{ClusterPredictions$new()}}
\item \href{#method-ClusterPredictions-add}{\code{ClusterPredictions$add()}}
\item \href{#method-ClusterPredictions-get}{\code{ClusterPredictions$get()}}
\item \href{#method-ClusterPredictions-getAll}{\code{ClusterPredictions$getAll()}}
\item \href{#method-ClusterPredictions-size}{\code{ClusterPredictions$size()}}
\item \href{#method-ClusterPredictions-getPositiveClass}{\code{ClusterPredictions$getPositiveClass()}}
\item \href{#method-ClusterPredictions-getClassValues}{\code{ClusterPredictions$getClassValues()}}
\item \href{#method-ClusterPredictions-clone}{\code{ClusterPredictions$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ClusterPredictions-new"></a>}}
\if{latex}{\out{\hypertarget{method-ClusterPredictions-new}{}}}
\subsection{Method \code{new()}}{
Method for initializing the object arguments during runtime.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ClusterPredictions$new(class.values, positive.class)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{class.values}}{A \link{character} vector containing the values of
the target class.}

\item{\code{positive.class}}{A \link{character} with the value of the positive
class.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ClusterPredictions-add"></a>}}
\if{latex}{\out{\hypertarget{method-ClusterPredictions-add}{}}}
\subsection{Method \code{add()}}{
The function is used to add the prediction achieved by a
specific M.L. model.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ClusterPredictions$add(prediction)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{prediction}}{A \code{\link{Prediction}} object containing the
computed predictions.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ClusterPredictions-get"></a>}}
\if{latex}{\out{\hypertarget{method-ClusterPredictions-get}{}}}
\subsection{Method \code{get()}}{
The function returns the predictions placed at specific
position.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ClusterPredictions$get(position)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{position}}{A \link{numeric} value indicating the position of the
predictions to be obtained.}
}
\if{html}{\out{</div>}}
}
\subsection{Returns}{
A \code{\link{Prediction}} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ClusterPredictions-getAll"></a>}}
\if{latex}{\out{\hypertarget{method-ClusterPredictions-getAll}{}}}
\subsection{Method \code{getAll()}}{
The function returns all the predictions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ClusterPredictions$getAll()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{list} containing all computed predictions.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ClusterPredictions-size"></a>}}
\if{latex}{\out{\hypertarget{method-ClusterPredictions-size}{}}}
\subsection{Method \code{size()}}{
The function returns the number of computed predictions.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ClusterPredictions$size()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{numeric} value.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ClusterPredictions-getPositiveClass"></a>}}
\if{latex}{\out{\hypertarget{method-ClusterPredictions-getPositiveClass}{}}}
\subsection{Method \code{getPositiveClass()}}{
The function gets the value of the positive class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ClusterPredictions$getPositiveClass()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{character} vector of size 1.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ClusterPredictions-getClassValues"></a>}}
\if{latex}{\out{\hypertarget{method-ClusterPredictions-getClassValues}{}}}
\subsection{Method \code{getClassValues()}}{
The function returns all the values of the target class.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ClusterPredictions$getClassValues()}\if{html}{\out{</div>}}
}

\subsection{Returns}{
A \link{character} vector containing all target values.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-ClusterPredictions-clone"></a>}}
\if{latex}{\out{\hypertarget{method-ClusterPredictions-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{ClusterPredictions$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
