% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tSNE-class.R
\docType{class}
\name{tSNE-class}
\alias{tSNE-class}
\title{S4 tSNE Class}
\value{
A Dimensionality Reduction advanced analysis object
}
\description{
A tSNE object that holds pertinent tSNE advanced analysis run information.
This class should never be called explicitly. If a user would like to create a new Cytobank Dimensionality Reduction object, utilize the \link{dimensionality_reduction.new} function, or any other \link[=dimensionality_reduction]{Dimensionality Reduction endpoints that return Dimensionality Reduction objects documented in the 'Details' section}.
}
\section{Slots}{

\describe{
\item{\code{iterations}}{numeric representing the number of times Dimensionality Reduction processes the dataset using its step-wise optimization algorithm, \href{https://support.cytobank.org/hc/en-us/articles/206439707-How-to-Configure-and-Run-a-Dimensionality\%20Reduction-Analysis\%23tSNE-CUDA}{learn more about how iterations affect Dimensionality Reduction results}}

\item{\code{perplexity}}{numeric representing a rough guess for the number of close neighbors any given cellular event will have, \href{https://support.cytobank.org/hc/en-us/articles/206439707-How-to-Configure-and-Run-a-Dimensionality\%20Reduction-Analysis\%23tSNE-CUDA}{learn more about Dimensionality Reduction perplexity}}

\item{\code{auto_iterations}}{logical representing whether or not to set auto interations}

\item{\code{auto_learning_rate}}{logical representing whether or not to set auto learning rate}

\item{\code{clustering_channels}}{list the channels selected for the Dimensionality Reduction analysis, this can be either a list of short channel IDs (integer) OR long channel names (character)}

\item{\code{desired_events_per_file}}{numeric representing the number of desired events per file}

\item{\code{desired_total_events}}{numeric representing the number of desired total events per file}

\item{\code{early_exaggeration}}{numeric representing how tight natural clusters in the original space are in the embedded space and how much space will be between them}

\item{\code{event_sampling_method}}{character representing the name of event sampling method will be used, \href{https://support.cytobank.org/hc/en-us/articles/206439707-How-to-Configure-and-Run-a-Dimensionality\%20Reduction-Analysis#Event-Sampling}{learn more about Event Sampling for Dimensionality Reduction analysis}}

\item{\code{fcsfile_ids}}{list representing the fcs file ids}

\item{\code{gateset_id}}{numeric representing the selected gate id}

\item{\code{learning_rate}}{numeric representing the learning rate}

\item{\code{normalize_scales}}{logical representing whether or not to normalize scales}
}}

