% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/authenticate.R
\docType{methods}
\name{authentication}
\alias{authentication}
\alias{authenticate}
\alias{authentication.logout,UserSession-method}
\alias{authentication.logout}
\alias{authentication.revoke_all_tokens,UserSession-method}
\alias{authentication.revoke_all_tokens}
\alias{authentication.revoke_all_tokens_user,UserSession-method}
\alias{authentication.revoke_all_tokens_user}
\title{Authentication Endpoints}
\usage{
authenticate(site, username = NA, password = NA, auth_token = NA,
  short_timeout = 30, long_timeout = 60, timeout = 30)

\S4method{authentication.logout}{UserSession}(UserSession,
  timeout = UserSession@short_timeout)

\S4method{authentication.revoke_all_tokens}{UserSession}(UserSession,
  timeout = UserSession@short_timeout)

\S4method{authentication.revoke_all_tokens_user}{UserSession}(UserSession,
  user_id, timeout = UserSession@short_timeout)
}
\arguments{
\item{site}{character representing Cytobank user's site}

\item{username}{character representing Cytobank user's username or email}

\item{password}{character representing Cytobank user's password}

\item{auth_token}{character representing Cytobank user's authentication token (expires in 8 hours)}

\item{short_timeout}{numeric representing short request timeout times (default = 60s) \strong{[optional]}}

\item{long_timeout}{numeric representing long request timeout times (default = 30s) \strong{[optional]}}

\item{timeout}{integer representing the request timeout time in seconds \strong{[optional]}}

\item{UserSession}{Cytobank UserSession object}

\item{user_id}{integer representing a Cytobank user's ID}
}
\description{
Interact with authentication endpoints. Every call to the Cytobank API must be accompanied by an authentication token. Tokens should be kept secure as they confer access to the data and analyses of an account. Tokens expire after 8 hours by default but this figure my change depending on custom configurations of an Enterprise Cytobank. Use the authentication.logout / authentication.revoke API endpoints to invalidate one or all tokens for a user account.
}
\details{
\code{authenticate} Authenticate a Cytobank user and returns a Cytobank UserSession object that is passed to all other Cytobank API endpoints.

\code{authentication.logout} Logout a Cytobank user.

\code{authentication.revoke_all_tokens} Invalidate all existing tokens for the user making this call.

\code{authentication.revoke_all_tokens_user} Revoke all tokens for a given user. This endpoint only works for admins of the Cytobank site being accessed.
}
\examples{
\donttest{# Authenticate via username/password
cyto_session <- authenticate(site="premium", username="cyril_cytometry", password="cytobank_rocks!")
# Authenticate via auth_token
cyto_session <- authenticate(site="premium", auth_token="my_secret_auth_token")
}
\donttest{authentication.logout(cyto_session)
}
\donttest{authentication.revoke_all_tokens(cyto_session)
}
\donttest{authentication.revoke_all_tokens_user(cyto_session)
}
}
