% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/quaternary.R
\name{writeQuaternaryGIF}
\alias{writeQuaternaryGIF}
\title{Create GIF image for dynamic rotating view of 3D quaternary simplex plot}
\usage{
writeQuaternaryGIF(
  x,
  ...,
  cluster = NULL,
  gifPath = "quaternary.gif",
  tmpDir = tempdir(),
  fps = 10,
  degreePerFrame = 10
)
}
\arguments{
\item{x}{Input object that \code{\link{plotQuaternary}} accepts.}

\item{...}{All other arguments needed for \code{\link{plotQuaternary}}. Must
be specified with exact argument names instead of a positional manner.}

\item{cluster}{One cluster that exists in \code{clusterVar}, if users
need to view the plot for specific group. Default \code{NULL} plot all cells.}

\item{gifPath}{Output GIF image file path. Default \code{"quaternary.gif"}}

\item{tmpDir}{A temprorary directory to store all PNG files for all
perspectives created. Default \code{tempdir()}.}

\item{fps}{Number of frame per second, must be a factor of 100. Default
\code{10}.}

\item{degreePerFrame}{Number of degree that the tetrahedron is rotated per
frame. Default \code{10}.}
}
\value{
No object is returned. The \code{tmpDir} folder will be created with
\code{360 / degreePerFrame} PNG image files in it. A GIF image file will be
created at \code{gifPath}.
}
\description{
Create GIF image for dynamic rotating view of 3D quaternary simplex plot
}
\examples{
gene <- selectTopFeatures(rnaRaw, rnaCluster, c("RE", "OS", "CH", "ORT"))
\donttest{
writeQuaternaryGIF(rnaRaw, clusterVar = rnaCluster, features = gene,
                   vertices = c("RE", "OS", "CH", "ORT"),
                   gifPath = paste0(tempfile(), ".gif"))
}
}
