% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Label_Prop_sto.R
\name{Label_Prop_sto_r}
\alias{Label_Prop_sto_r}
\title{Computes a classification on the target data}
\usage{
Label_Prop_sto_r(
  X_s,
  X_t,
  Lab_source,
  eps = 1e-04,
  const = 0.1,
  n_iter = 4000,
  minMaxScaler = TRUE,
  monitoring = TRUE,
  thresholding = TRUE
)
}
\arguments{
\item{X_s}{a cytometry dataframe. The columns correspond to the different biological markers tracked.
One line corresponds to the cytometry measurements performed on one cell. The classification
of this Cytometry data set must be provided with the Lab_source parameters.}

\item{X_t}{a cytometry dataframe. The columns correspond to the different biological markers tracked.
One line corresponds to the cytometry measurements performed on one cell. The CytOpT algorithm
targets the cell type proportion in this Cytometry data set}

\item{Lab_source}{a vector of length \code{n} Classification of the X_s cytometry data set}

\item{eps}{an float value of regularization parameter of the Wasserstein distance. Default is \code{1e-04}}

\item{const}{an float constant. Default is \code{1e-01}}

\item{n_iter}{an integer Constant that iterate method select. Default is \code{4000}}

\item{minMaxScaler}{a logical flag indicating to possibly Scaler}

\item{monitoring}{a logical flag indicating to possibly monitor the gap between the estimated proportions and the manual
gold-standard. Default is \code{FALSE}}

\item{thresholding}{a logical flag.}
}
\value{
a \code{\link[ggplot2]{ggplot}} object

a vector of length \code{nrow(X_t)} with the propagated labels
}
\description{
Computes a classification on the target data thanks to the approximation of 
the transport plan and the classification of the source data.
Transport plan is approximated with the stochastic algorithm.
}
\examples{

if(interactive()){

res <- Label_Prop_sto_r(X_s = HIPC_Stanford_1228_1A, X_t = HIPC_Stanford_1369_1A, 
             Lab_source = HIPC_Stanford_1228_1A_labels)

}

}
