\name{adaptive.chi.square}
\alias{adaptive.chi.square}
%- Also NEED an '\alias' for EACH other topic documented here.
\title{
Adaptive Chi-Square Test
}
\description{
Performs Adaptive Chi-Square test of Ryabko et al.(2004) to evaluate the randomness of an RNG. 
}
\usage{
adaptive.chi.square(A, B, S, alpha = 0.05, prop=0.5, bit=FALSE)
}
%- maybe also 'usage' for other objects documented here.
\arguments{

  \item{A}{
       a vector or matrix that includes random data. See details for further information.
}
  \item{B}{
       the length of words (B-bit) that the chippered file will be divided into.
}
  \item{S}{
      the number of subsets where letters of an alphabet are combined, and \eqn{S \ge 2}
}
  \item{alpha}{
      a predetermined value of type-I error with the default value of 0.05.
}
  \item{prop}{
      a predetermined value of proportion of training data set.
}
\item{bit}{
      if \code{A} contains a sequence of bits, \code{bit} is set \code{TRUE}. Otherwise, a sequence of integers is entered and \code{bit} is set \code{FALSE}.
}
}
\details{
It is possible to apply adaptive Chi-Square to smaller samples than that required for the regular chi-square test. 

If \code{A} contains a sequence of bits, then \code{A} should be a matrix of \eqn{B}x\eqn{k}, where \eqn{k} is the number of words (integers) generated by the RNG of interest. Otherwise, \code{A} is a \eqn{k}x\eqn{1} vector of the words. Because bits will be converted to base 10 before application of the test, implementation time will be shorter with integer input.

The degrees of freedom of the resulting chi-square test is \code{S-1}. The value of \code{S} should be much less than \eqn{2^B}. 
}
\value{
\item{statistic}{
     calculated value of the test statistic.
}
\item{p.value}{
     p-value of the test.
}
\item{result.acsq}{
    returns 0 if H0 is rejected and 1 otherwise.
}
}
\references{
Ryabko, B.Ya., Stognienko, V.S., Shokin Yu.I., A new test for randomness and its application to some cryptographic problems. Journal of Statistical Planning and Inference (2004), 123, 365--376.
}
\author{
Haydar Demirhan

Maintainer: Haydar Demirhan <haydarde@hacettepe.edu.tr>
}

\examples{

RNGkind(kind = "Super-Duper")
B=16                  # Bit length is 16.
k=5000                # Generate 5000 integers.
A=0
A=round(runif(k,0,(2^B-1)))
S=2                   # Divide alphabet to two subsets.
alpha = 0.05
test=adaptive.chi.square(A, B, S, alpha, bit =FALSE)
print(test)
}

\keyword{goodness-of-fit test }
\keyword{randomness test }% __ONLY ONE__ keyword per line
\keyword{nonparametric }
