% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/efficiency.R
\name{design.efficiency}
\alias{design.efficiency}
\title{Create the design matrix, variance-covariance matrix, the variance of each
pairwise comparison and the efficicency of each pairwise comparison for a
cross-over design}
\usage{
design.efficiency(design, model = 1, model.param = list(),
  v = length(levels(as.factor(design))))
}
\arguments{
\item{design}{Cross-over design.}

\item{model}{Model - one of the following: 1) "Standard additive model",
2) "Second-order carry-over effects", 3) "Full set of interactions",
4) "Self-adjacency model", 5) "Placebo model", 6) "No carry-over into self
model", 7) "Treatment decay model", 8) "Proportionality model", 9) "No carry-over effects".}

\item{model.param}{List of additional model specific parameters. In the
moment these are \code{ppp}, the proportionality parameter for the
proportionality model, and \code{placebos}, the number of placebo treatments
in the placebo model.}

\item{v}{Number of treatments}
}
\value{
A list with the following elements:
\itemize{
\item xmat Design matrix for the given model (including subject and period effects)
\item var.trt.pair.adj Matrix of treament difference variances
\item eff.trt.pair.adj Matrix of treament difference efficiencies
}
}
\description{
Function to read in a cross-over design and create the design matrix X, 
the variance of each pairwise comparison and the efficicency of each pairwise comparison.
}
\details{
See the vignette of this package for further details.
}
\examples{

design.efficiency(getDesign("fletcher1"))
design.efficiency(getDesign("fletcher1"), model=7)
design.efficiency(getDesign("switchback4t"), model=7)

}
\author{
Kornelius Rohmeyer \email{rohmeyer@small-projects.de}
}
\references{
Jones, B., & Kenward, M. G. (2003). Design and analysis of
cross-over trials (Vol. 98). Chapman & Hall.
}
\keyword{misc}

