% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cc_test_ari_permutation.R
\name{cc_test_ari_permutation}
\alias{cc_test_ari_permutation}
\title{A permutation test for testing the null hypothesis of
random agreement (i.e., adjusted Rand Index equal to 0) between
two partitions.}
\usage{
cc_test_ari_permutation(ground_truth, partition)
}
\arguments{
\item{ground_truth}{(int) A vector of the actual membership of elements
in clusters}

\item{partition}{The partition coming from a clustering algorithm}
}
\value{
A data_frame with two columns:
\item{ari}{the adjusted Rand Index}
\item{p_value}{the p-value of the test}
}
\description{
A permutation test for testing the null hypothesis of
random agreement (i.e., adjusted Rand Index equal to 0) between
two partitions.
}
\examples{
library(CrossClustering)

clusters <- iris[-5] |>
  dist() |>
  hclust(method = 'ward.D') |>
  cutree(k = 3)

ground_truth <- iris[[5]] |>
  as.numeric()

cc_test_ari_permutation(ground_truth, clusters)

}
\references{
Samuh M. H., Leisch F., and Finos L. (2014), Tests for Random Agreement
in Cluster Analysis, Statistica Applicata-Italian Journal of Applied
Statistics, vol. 26, no. 3, pp. 219-234.

L. Hubert and P. Arabie (1985) Comparing partitions, Journal of
Classification, 2, 193-218.
}
\author{
Paola Tellaroli, <paola \code{dot} tellaroli \code{at} unipd \code{dot} it>;
Livio Finos, <livio \code{dot} finos \code{at} unipd \code{dot} it>
}
