% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CrossGEEKron.R
\name{CrossGEEKron}
\alias{CrossGEEKron}
\title{Run a GEE model for data from a crossover experiment with
 repeated measures}
\source{
https://doi.org/10.1007/s00362-022-01391-z
}
\usage{
CrossGEEKron(
  response,
  period,
  treatment,
  id,
  time,
  carry,
  covar = NULL,
  data,
  family = gaussian(),
  correlation = "independence",
  formula = NULL,
  tol = 1e-04,
  niter = 100,
  Mv
)
}
\arguments{
\item{response}{A character string specifying the name of the
response variable of the crossover experimental design}

\item{period}{A character string specifying the name of vector with the
observation period of the responses of  the crossover experimental design}

\item{treatment}{A character string specifying the name of vector with the
treatment applied at each observation of the crossover experimental design}

\item{id}{A  character string specifying the name of vector which identifies
the experimental units. The length of ‘id’
should be the same as the number of observations. Data are assumed to be sorted so
that observations on each cluster appear as contiguous rows in data. If data
is not sorted this way, the function will not identify the clusters correctly.
 If data is not sorted this way, a warning will be issued.}

\item{time}{A character string specifying the name of the vector with the
measurement time within each period}

\item{carry}{A vector of  character string specifying the name set of dummy
 variables that indicates the treatment applied
in the previous period of each experimental unit. They must be 0 in period 1}

\item{covar}{A vector of  character string specifying the name of possible
covariates of the crossover experimental design}

\item{data}{A data frame with all the variables of the crossover experimental design}

\item{family}{See corresponding documentation to \code{glm}.}

\item{correlation}{a character string specifying the correlation structure.
 The following are permitted: "independence", "fixed", "stat_M_dep",
"non_stat_M_dep", "exchangeable", "AR-M" and "unstructured"}

\item{formula}{A formula related the response variable with the explanatory
 variables. If it is \code{NULL} the formula,
\code{response~period+treatment+carry+time+covar} will be evaluated}

\item{tol}{the tolerance used in the fitting algorithm.}

\item{niter}{the maximum number of iterations.
\code{response~period+treatment+carry+time+covar} will be evaluated.}

\item{Mv}{When correlation is "stat_M_dep", "non_stat_M_dep", or "AR-M"
then Mv must be specified.}
}
\value{
A list with:
\item{QIC}{The QIC of the model: The model are fitted by \code{geeglm}.}
\item{model}{The model fitted by \code{geeglm}.}
\item{Within}{The estimated correlation matrix within the period
with the structure determined by \code{correlation}}.
\item{Between}{The estimated correlation matrix between periods.}
}
\description{
Provides a GEE model for the data of a crossover design with S
sequences of T periods. There must be at least two observations of each
experimental unit in each period.
}
\examples{
data(Arterial)

carrydata <- createCarry(data=Arterial, treatment = "Treatment",
 period = "Period",id="Subject")

data <- carrydata$data
carry <- carrydata$carryover
model <- CrossGEEKron(response = "Pressure", treatment = "Treatment",
period = "Period", id="Subject", time="Time",
 carry=c("Carry_B","Carry_C"),data=data, correlation = "AR-M", Mv=1)

model$QIC
model$Within
model$Between
summary(model$model)

## Aproximate p-values for model
(pvalues <- 2 * pnorm(abs(coef(summary(model$model))[,5]), lower.tail = FALSE))

model2 <- CrossGEEKron(response = "Pressure", treatment = "Treatment",
 period = "Period", id="Subject", time="Time",
 carry=c("Carry_B","Carry_C"), data=data,
 correlation = "AR-M", Mv=1,formula=Pressure ~ Treatment+
 Period+ Carry_B+Carry_C)

model2$QIC
model2$Within
model2$Between
summary(model2$model)


}
\references{
Cruz, N.A., Melo, O.O. & Martinez, C.A.
 A correlation structure for the analysis of Gaussian and non-Gaussian
  responses in crossover experimental designs with repeated measures.
   Statistical Papers 65, 263–290 (2024)
}
