% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vimp.covregrf.R
\name{vimp.covregrf}
\alias{vimp.covregrf}
\alias{vimp}
\title{Variable importance for covregrf objects}
\usage{
\method{vimp}{covregrf}(object, ...)
}
\arguments{
\item{object}{An object of class (covregrf, grow).}

\item{...}{Optional arguments to be passed to other methods.}
}
\value{
An object of class \code{(covregrf, vimp)} which is a list with the
  following component:

  \item{importance}{Variable importance measures (VIMP) for covariates.}
}
\description{
Calculates variable importance measures (VIMP) for covariates for training
  data.
}
\examples{
options(rf.cores=2, mc.cores=2)

## load generated example data
data(data, package = "CovRegRF")
xvar.names <- colnames(data$X)
yvar.names <- colnames(data$Y)
data1 <- data.frame(data$X, data$Y)

## define train/test split
set.seed(2345)
smp <- sample(1:nrow(data1), size = round(nrow(data1)*0.6), replace = FALSE)
traindata <- data1[smp,,drop=FALSE]
testdata <- data1[-smp, xvar.names, drop=FALSE]

## formula object
formula <- as.formula(paste(paste(yvar.names, collapse="+"), ".", sep=" ~ "))

## train covregrf
covregrf.obj <- covregrf(formula, traindata, params.rfsrc = list(ntree = 50),
  importance = TRUE)

## get the variable importance measures
vimp <- covregrf.obj$importance
vimp2 <- vimp(covregrf.obj)$importance


}
\seealso{
\code{\link{plot.vimp.covregrf}}
}
