#' Flexible Univariate Count Models Based on Renewal Processes
#'
#' Flexible univariate count models based on renewal
#' processes. The models may include covariates and can be specified
#' with familiar formula syntax as in glm() and 'flexsurv'.
#'
#' @docType package
#' @name Countr
#' @aliases  Countr-package
#' @import Matrix Rcpp Formula flexsurv dplyr
#' @importFrom stats nobs AIC  coef  confint  confint.default
#' @importFrom stats formula  getCall  glm.fit  logLik  model.frame
#' @importFrom stats model.matrix  model.response  model.weights
#' @importFrom stats na.pass  pnorm  poisson  printCoefmat  quantile
#' @importFrom stats dnbinom dpois lm pchisq
#' @importFrom stats residuals update.formula  vcov
#' @importFrom stats density predict qqline qqnorm terms.formula
#' @importFrom graphics par plot
#' @importFrom RColorBrewer brewer.pal
#' @importFrom lattice barchart
#' @importFrom car Boot
#' @importFrom Rdpack reprompt
#' @importFrom utils capture.output
#' @importFrom standardize standardize
#' @importFrom lmtest lrtest
#' @importFrom xtable xtable
#' @useDynLib Countr
#'
#' @description The main function is \code{\link{renewalCount}}, see its
#'     documentation for examples.
#'
#' Goodness of fit chi-square (likelihood ratio and Pearson) tests for glm and
#'     count renewal models are implemented in \code{\link{chiSq_gof}} and
#'     \code{\link{chiSq_pearson}}.
#'
#' @references
#' \insertRef{baker2017event}{Countr}
#'
#' \insertRef{boshnakov2017bivariate}{Countr}
#'
#' \insertRef{cameron2013regression}{Countr}
#'
#' \insertRef{mcshane2008count}{Countr}
#'
#' \insertRef{winkelmann1995duration}{Countr}
#'
NULL

## To stop the respective NOTE from R CMD check
utils::globalVariables(
    c("Counts", "Actual" # see compareToGLM()
      )
)
