% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.cdtafit}
\alias{print.cdtafit}
\title{Print a summary of the fitted model.}
\usage{
\method{print}{cdtafit}(x, digits = 3, ...)
}
\arguments{
\item{x}{An cdtafit object from \link{fit}.}

\item{digits}{An optional positive value to control the number of digits to print when printing numeric values. The default is 3.}

\item{...}{other \link[rstan]{stan} options.}
}
\value{
The posterior mean and 95 percent credible intervals, n_eff, Rhat and WAIC.
}
\description{
Print a summary of the fitted model.
}
\examples{
data(telomerase)
model1 <-  cdtamodel(copula = 'fgm')

model2 <- cdtamodel(copula = 'fgm',
               modelargs=list(param=2,
                              prior.lse='normal',
                              par.lse1=0,
                              par.lse2=5,
                              prior.lsp='normal',
                              par.lsp1=0,
                              par.lsp2=5))

model3 <-  cdtamodel(copula = 'fgm',
               modelargs = list(formula.se = StudyID ~ Test - 1))
\dontrun{

fit1 <- fit(model1,
                SID='ID',
                data=telomerase,
                iter=2000,
                warmup=1000,
                thin=1,
                seed=3)

print(fit1)

}
}
\references{
{Watanabe S (2010). Asymptotic Equivalence of Bayes Cross Validation and Widely Applicable Information Criterion in Singular
Learning Theory. Journal of Machine Learning Research, 11, 3571-3594.}

{Vehtari A, Gelman A (2014). WAIC and Cross-validation in Stan. Unpublished, pp. 1-14.}
}
\author{
Victoria N Nyaga
}
