% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ic_par_copula.R
\name{ic_par_copula}
\alias{ic_par_copula}
\title{Copula regression models with parametric margins for bivariate interval-censored data}
\source{
Tao Sun, Yi Liu, Richard J. Cook, Wei Chen and Ying Ding (2018).
Copula-based Score Test for Bivariate Time-to-event Data, with Application to a Genetic Study of AMD Progression.
\emph{Lifetime Data Analysis} doi:10.1007/s10985-018-09459-5. \cr
Tao Sun and Ying Ding (2019).
Copula-based Semiparametric Transformation Model for Bivariate Data Under General Interval Censoring.
http://arxiv.org/abs/1901.01918.
}
\usage{
ic_par_copula(data, var_list, copula, m.dist = "Loglogistic",
  method = "Newton", iter = 300, stepsize = 1e-05, hes = TRUE)
}
\arguments{
\item{data}{a data frame; must have id (subject id), ind (1,2 for two units in each subject),
Left (0 if left-censoring), Right (Inf if right-censoring), status (0 for right-censoring, 1 for interval-censoring or left-censoring), and covariates by column.}

\item{var_list}{the list of covariates to be fitted into the copula model.}

\item{copula}{Types of copula model.}

\item{m.dist}{baseline marginal distribution.}

\item{method}{optimization method; default is "Newton" (from nlm).}

\item{iter}{number of iterations; default is 300.}

\item{stepsize}{size of optimization step; default is 1e-5.}

\item{hes}{default = T for hessian calculation.}
}
\value{
a CopulaCenR object summarizing the model. Can be used as an input to general S3 methods including
summary, plot, lines, coef, logLik, predict.
}
\description{
Fits a copula model with parametric margins for bivariate interval-censored data.
}
\details{
The supported copula models are "Clayton", "Gumbel", "Frank", "AMH", "Joe", "Copula2".
The "Copula2" model is a two-parameter copula model that incorporates Clayton and Gumbel as special cases.
The supported marginal distributions are "Weibull" (proportional hazards), "Gompertz" (proportional hazards) and "Loglogistic" (proportional odds).
We assume the same baseline parameters between two margins. \cr

The input data must be a data frame. with columns id (sample id), ind (1,2 for the two units from the same id),
Left (0 if left-censoring), Right (Inf if right-censoring), status (0 for right-censoring, 1 for interval-censoring or left-censoring), and covariates. Do not allow Left == Right. \cr

Optimization methods can be "Newton" (from nlm) and all methods from optim, such as "Nelder-Mead", "BFGS", "CG", "L-BFGS-B", "SANN". "Brent" is not allowed due to more than one estimators.
}
\examples{
# fit a Copula2-Loglogistic model
data(AREDS)
copula2_loglog <- ic_par_copula(data = AREDS, copula = "Copula2",
                  m.dist = "Loglogistic",
                  var_list = c("ENROLLAGE","rs2284665","SevScaleBL"),
                  method = "Newton", iter = 300, stepsize = 1e-6)
summary(copula2_loglog)
}
