% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/retrieve.R
\name{cds_build_request}
\alias{cds_build_request}
\title{Prepare a request for downloading a dataset}
\usage{
cds_build_request(dataset, ...)
}
\arguments{
\item{dataset}{The dataset name to be used for setting up a request.}

\item{...}{Parameters for subsetting the dataset. Use \code{cds_dataset_form()} to inquiry
which parameters and parameter values are available for a specific dataset.
If left blank it will take default parameter values.}
}
\value{
Returns a named list, which can be used to submit a job (\code{cds_submit_job()})
or inquiry its cost (\code{cds_estimate_costs()}).
}
\description{
This function is used by \code{cds_estimate_costs()} and \code{cds_submit_job()}
to subset a dataset before downloading. It will also help you to explore
which parameters are available for subsetting.
}
\examples{
if (interactive()) {
  cds_build_request(
    dataset        = "reanalysis-era5-pressure-levels",
    variable       = "geopotential",
    product_type   = "reanalysis",
    area           = c(n = 55, w = -1, s = 50, e = 10),
    year           = "2024",
    month          = "03",
    day            = "01",
    pressure_level = "1000",
    data_format    = "netcdf"
  )
}
}
