% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParameterChecks_CoopGame.R
\name{stopOnInvalidEstate}
\alias{stopOnInvalidEstate}
\title{Parameter Function stopOnInvalidEstate}
\usage{
stopOnInvalidEstate(paramCheckResult, E)
}
\arguments{
\item{paramCheckResult}{list object for check result with list element 'errCode' for the error code
and 'errMessage' for the error message.}

\item{E}{is the value of the estate in a bankruptcy game}
}
\description{
stopOnInvalidBankruptcy checks if estate
 is specified correctly (as parameter in a bankruptcy game).
 Validation result gets stored to object paramCheckResult 
 in case an error occured and causes stop otherwise.
}
\section{Error Code Ranges}{

Error codes and messages shown to user if error on parameter check occurs
\tabular{lll}{
\strong{Error Code} \tab \strong{Message} \cr
1150 \tab Estate must be nonnegative! \cr
1151 \tab Estate must be numeric! \cr
1152 \tab Invalid estate as E is NULL}
}

\examples{
library(CoopGame)
paramCheckResult=getEmptyParamCheckResult()
validEstate = 55
stopOnInvalidEstate(paramCheckResult, E=validEstate)

}
\seealso{
Other ParameterChecks_CoopGame: \code{\link{getEmptyParamCheckResult}},
  \code{\link{stopOnInconsistentEstateAndClaimsVector}},
  \code{\link{stopOnInvalidAllocation}},
  \code{\link{stopOnInvalidBoolean}},
  \code{\link{stopOnInvalidClaimsVector}},
  \code{\link{stopOnInvalidCoalitionS}},
  \code{\link{stopOnInvalidDictator}},
  \code{\link{stopOnInvalidGameVector}},
  \code{\link{stopOnInvalidGrandCoalitionN}},
  \code{\link{stopOnInvalidIndex}},
  \code{\link{stopOnInvalidLeftRightGloveGame}},
  \code{\link{stopOnInvalidNChooseB}},
  \code{\link{stopOnInvalidNumberOfPlayers}},
  \code{\link{stopOnInvalidNumber}},
  \code{\link{stopOnInvalidQuota}},
  \code{\link{stopOnInvalidVetoPlayer}},
  \code{\link{stopOnInvalidWeightVector}},
  \code{\link{stopOnParamCheckError}}
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
\concept{ParameterChecks_CoopGame}
