% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ParameterChecks_CoopGame.R
\name{stopOnInconsistentEstateAndClaimsVector}
\alias{stopOnInconsistentEstateAndClaimsVector}
\title{Parameter Function stopOnInconsistentEstateAndClaimsVector}
\usage{
stopOnInconsistentEstateAndClaimsVector(paramCheckResult, E, d)
}
\arguments{
\item{paramCheckResult}{list object for check result with list element 'errCode' for the error code
and 'errMessage' for the error message.}

\item{E}{is the value of the estate in a bankruptcy game}

\item{d}{numeric vector which contains the claims of each player in a bankruptcy game}
}
\description{
stopOnInconsistentEstateAndClaimsVector
checks if 
sum of claims is greater or equal estate (in bankruptcy games).
Calculation stops with an error message if claims vector and estate are inconsistent.
}
\section{Error Code Ranges}{

Error codes and messages shown to user if error on parameter check occurs
\tabular{lll}{
\strong{Error Code} \tab \strong{Message} \cr
1170 \tab Estate E must be less or equal the sum of claims!}
}

\examples{
library(CoopGame)
paramCheckResult=getEmptyParamCheckResult()
consistentClaims= c(26,27,55,57)
consistentE = 110
stopOnInconsistentEstateAndClaimsVector(paramCheckResult, d=consistentClaims, E=consistentE)

}
\seealso{
Other ParameterChecks_CoopGame: \code{\link{getEmptyParamCheckResult}},
  \code{\link{stopOnInvalidAllocation}},
  \code{\link{stopOnInvalidBoolean}},
  \code{\link{stopOnInvalidClaimsVector}},
  \code{\link{stopOnInvalidCoalitionS}},
  \code{\link{stopOnInvalidDictator}},
  \code{\link{stopOnInvalidEstate}},
  \code{\link{stopOnInvalidGameVector}},
  \code{\link{stopOnInvalidGrandCoalitionN}},
  \code{\link{stopOnInvalidIndex}},
  \code{\link{stopOnInvalidLeftRightGloveGame}},
  \code{\link{stopOnInvalidNChooseB}},
  \code{\link{stopOnInvalidNumberOfPlayers}},
  \code{\link{stopOnInvalidNumber}},
  \code{\link{stopOnInvalidQuota}},
  \code{\link{stopOnInvalidVetoPlayer}},
  \code{\link{stopOnInvalidWeightVector}},
  \code{\link{stopOnParamCheckError}}
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
\concept{ParameterChecks_CoopGame}
