% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PublicHelpChiIndexConcept.R
\name{publicHelpChiIndex}
\alias{publicHelpChiIndex}
\alias{publicHelpIndexChi}
\title{Compute Public Help index Chi}
\usage{
publicHelpChiIndex(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
Public Help index Chi for specified simple game
}
\description{
Calculates the Public Help index Chi for a specified simple TU game.
}
\examples{
library(CoopGame)
publicHelpChiIndex(v=c(0,0,0,0,1,0,1))

\donttest{
#Example from original paper by Stach (2016), p. 105:
library(CoopGame)
v=c(0,0,0,1,1,0,1)
publicHelpChiIndex(v) 
#result: 0.4583333 0.2708333 0.2708333

#Second example from original paper by Stach (2016), p. 105:
library(CoopGame)
v=c(0,0,0,0,1,1,0,0,0,0,1,1,1,0,1)
publicHelpChiIndex(v)
#result: 0.3981481 0.2376543 0.2376543 0.1265432
}

}
\references{
Bertini C. and Stach I. (2015) "On Public Values and Power Indices", Decision Making in Manufacturing and Services 9(1), pp. 9--25

Stach I. (2016) "Power Measures and Public Goods", In: Nguyen, N.T. and Kowalczyk, R. (Eds.): Transactions on Computational Collective Intelligence XXIII, Springer, pp. 99--110
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
