% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GameVector.R
\name{getZeroNormalizedGameVector}
\alias{getZeroNormalizedGameVector}
\title{Compute 0-normalized game vector}
\usage{
getZeroNormalizedGameVector(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
Numeric vector of length (2^n)-1 representing the zero-normalized game.
}
\description{
Computes the zero-normalized game for a given game specified by a game vector.
}
\examples{
library(CoopGame)
v<-c(1:7)
getZeroNormalizedGameVector(v)

}
\references{
Branzei R., Dimitrov D. and Tijs S. (2006) \emph{Models in cooperative game theory}, Springer, p. 9

Peleg B. and Sudhoelter P. (2007) \emph{Theory of cooperative games}, 2nd Edition, Springer, p. 11
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}

Johannes Anwander \email{anwander.johannes@gmail.com}
}
