% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getUnanimityCoefficients.R
\name{getUnanimityCoefficients}
\alias{getUnanimityCoefficients}
\alias{getHarsanyiDividends}
\title{Compute unanimity coefficients of game}
\usage{
getUnanimityCoefficients(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
numeric vector containing the unanimity coefficients
}
\description{
getUnanimityCoefficients calculates to unanimity coefficients of 
a specified TU game. Note that the unanimity coefficients are also frequently 
referred to as Harsanyi dividends in the literature.
}
\examples{
library(CoopGame)
getUnanimityCoefficients(c(0,0,0,60,48,30,72))
}
\references{
Peleg B. and Sudhoelter P. (2007) \emph{Theory of cooperative games}, 2nd Edition, Springer, p. 153

Gilles R. P. (2015)  \emph{The Cooperative Game Theory of Networks and Hierarchies}, Springer, pp. 15--17

Shapley L.S. (1953) "A value for n-person games". In: Kuhn, H., Tucker, A.W. (Eds.), Contributions to the Theory of Games II, Princeton University Press, pp. 307--317
}
\author{
Johannes Anwander \email{anwander.johannes@gmail.com}

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
