% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/TauConcept.R
\name{drawTauValue}
\alias{drawTauValue}
\alias{drawTijsValue}
\title{Draw tau-value for 3 or 4 players}
\usage{
drawTauValue(v, holdOn = FALSE, colour = NA, label = TRUE,
  name = "Tau value")
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}

\item{holdOn}{draws in a existing plot}

\item{colour}{draws the geometric object (i.e. point or convex polyhedron) with this colour, all colour names can be seen with "colors()"}

\item{label}{activates the labels for the figure}

\item{name}{set a name for the label}
}
\value{
None.
}
\description{
drawTauValue draws the tau-value for 3 or 4 players.
}
\examples{
library(CoopGame)
v <-c(1,2,3,60,60,60,142)
drawTauValue(v,colour="green")
}
\references{
Branzei R., Dimitrov D. and Tijs S. (2006) \emph{Models in cooperative game theory}, Springer, p. 32

Tijs S. (1981) "Bounds for the core of a game and the t-value", In: Moeschlin, O. and Pallaschke, D. (Eds.): Game Theory and Mathematical Economics, North-Holland, pp. 123--132

Stach I. (2011) "Tijs value", Encyclopedia of Power, SAGE Publications, pp. 667--670
}
\author{
Johannes Anwander \email{anwander.johannes@gmail.com}

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
