% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/NucleolusDerivatives.R
\name{drawDisruptionNucleolus}
\alias{drawDisruptionNucleolus}
\title{draw disruption nucleolus for 3 or 4 players}
\usage{
drawDisruptionNucleolus(v, holdOn = FALSE, colour = NA, label = TRUE,
  name = "Disruption Nucleolus")
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}

\item{holdOn}{draws in a existing plot}

\item{colour}{draws the geometric object (i.e. point or convex polyhedron) with this colour, all colour names can be seen with "colors()"}

\item{label}{activates the labels for the figure}

\item{name}{set a name for the label}
}
\value{
None.
}
\description{
drawDisruptionNucleolus draws the disruption nucleolus for 3 or 4 players.
}
\examples{
library(CoopGame)
v<-bankruptcyGameVector(n=3,d=c(100,200,300),E=200)
drawDisruptionNucleolus(v)

}
\references{
Littlechild S.C. and Vaidya K.G. (1976) "The propensity to disrupt and the disruption nucleolus of a characteristic function game", Int. Journal of Game Theory 5(2), pp. 151--161
}
\author{
Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
