% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BanzhafConcept.R
\name{banzhafValue}
\alias{banzhafValue}
\alias{nonNormalizedBanzhafValue}
\title{Compute Banzhaf value}
\usage{
banzhafValue(v)
}
\arguments{
\item{v}{Numeric vector of length 2^n - 1 representing the values of 
the coalitions of a TU game with n players}
}
\value{
The return value is a numeric vector which contains the Banzhaf value for each player.
}
\description{
banzhafValue computes the Banzhaf value for a specified TU game
             The Banzhaf value itself is an alternative to the Shapley value. \cr
             Conceptually, the Banzhaf value is very similar to the Shapley value. 
             Its main difference from the Shapley value is that the Banzhaf value is coalition
             based rather than permutation based. 
             Note that in general the Banzhaf vector is not efficient!
             In this sense this implementation of the Banzhaf value could also 
             be referred to as the non-normalized Banzhaf value, see formula (20.6) in 
             on p. 368 of the book by Hans Peters (2015).
}
\examples{
library(CoopGame)
v=c(0,0,0,1,2,1,4)
banzhafValue(v)

\donttest{
#Example from paper by Gambarelli (2011)
library(CoopGame)
v=c(0,0,0,1,2,1,3)
banzhafValue(v)
#[1] 1.25 0.75 1.25
}

}
\references{
Peters H. (2015)  \emph{Game Theory: A Multi-Leveled Approach}, 2nd Edition, Springer, pp. 367--370

Chakravarty S.R., Mitra M. and Sarkar P. (2015) \emph{A Course on Cooperative Game Theory}, Cambridge University Press, pp. 118--119

Gambarelli G. (2011) "Banzhaf value", Encyclopedia of Power, SAGE Publications, pp. 53--54
}
\author{
Johannes Anwander \email{anwander.johannes@gmail.com}

Jochen Staudacher \email{jochen.staudacher@hs-kempten.de}
}
