% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/IUCNeval.functionv11.R
\name{subpop.comp}
\alias{subpop.comp}
\title{Number of subpopulations}
\usage{
subpop.comp(XY, Resol_sub_pop = 5)
}
\arguments{
\item{XY}{string, indicating the method used for estimating the number of locations. Either "fixed_grid" or "sliding scale". See details. By default, it is "fixed_grid"}

\item{Resol_sub_pop}{numeric. Defines in kilometers the radius of the circles around each occurrence}
}
\value{
A list with one list for each taxa containing [[1]]Number of subpopulation and [[2]]SpatialPolygons.
}
\description{
Estimate the number of locations following the method **circular buffer method**
}
\details{
\strong{Input} as a \code{dataframe} should have the following structure:

\strong{It is mandatory to respect field positions, but field names do not matter}

\tabular{ccc}{
  [,1] \tab ddlat \tab numeric, latitude (in decimal degrees)\cr
  [,2] \tab ddlon \tab numeric, longitude (in decimal degrees)\cr
  [,3] \tab tax \tab character or factor, taxa names\cr
}
}
\examples{
data(dataset.ex)
\dontrun{
subpop <- subpop.comp(dataset.ex, Resol_sub_pop = 5)
}


}
\references{
Rivers MC, Bachman SP, Meagher TR, Lughadha EN, Brummitt NA (2010) Subpopulations, locations and fragmentation: applying IUCN red list criteria to herbarium specimen data. Biodiversity and Conservation 19: 2071-2085. doi: 10.1007/s10531-010-9826-9
}
\author{
Gilles Dauby, \email{gildauby@gmail.com}
}
