% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{predict.GIC.FuncompCGL}
\alias{predict.GIC.FuncompCGL}
\title{Make predictions based on a \code{"GIC.FuncompCGL"} object.}
\usage{
\method{predict}{GIC.FuncompCGL}(object, Znew, Zcnew = NULL,
        s = "lam.min", k = NULL, ...)
}
\arguments{
\item{object}{fitted \code{\link{GIC.FuncompCGL}} object.}

\item{Znew}{data frame or matrix \code{X} as in \code{FuncompCGL} with new
functional compositional data at which prediction is to be made.}

\item{Zcnew}{matrix \code{Zc} as in \code{FuncompCGL} with new values of
time-invariate covariates at which prediction is to be made.
Default is \code{NULL}.}

\item{s}{value(s) of the regularization parameter \code{lam} at which coefficients are requested.
\itemize{
\item \code{s="lam.min"} (default), grid value of \code{lam} and \code{k} stored in
      \code{"GIC.FuncompCGL"} object such that the minimun value of GIC is achieved.
\item If \code{s} is numeric, it is taken as the value(s) of \code{lam} to be used.
      In this case, k must be provided.
\item If \code{s = NULL}, used the whole sequence of \code{lam} stored in the \code{GIC.FuncompCGL}
      object.
}}

\item{k}{value(s) of degrees of freedom of the basis function at which coefficents are requested.
\code{k} can be \code{NULL} (default) or integer(s).
\itemize{
\item \code{k = NULL}, \code{s} must be \code{"lam.min"}.
\item if \code{k} is integer(s), it is taken as the value of \code{k} to be used
      and it must be one(s) of these in \code{"GIC.FuncompCGL"} model.
}}

\item{...}{Other arguments passed to \code{predict.FuncompCGL}}
}
\value{
The prediction values at the requested value(s) for \code{s} and \code{k}.
If \code{k} is a vector, a list of prediction matrix is returned,
otherwise a prediction matrix is returned.
}
\description{
This function makes prediction based on a \code{"GIC.FuncompCGL"} object, using the
stored \code{"FuncompCGL.fit"} object and the optimal values of
the regularization parameter \code{lam} and the degrees of freedom \code{k}.
}
\details{
\code{s} is the vector at which predictions are requested. If \code{s} is not in the \code{lam}
sequence used for fitting the model, the \code{predict} function uses linear interpolation.
\cr
If the data frame \code{X} is provided in \code{FuncompCGL} mode, the integral
for new data \code{newx} is taken the same as that in the fitted
\code{FuncompCGL} model. This means that the parameters \code{degree},
\code{basis_fun}, \code{insert}, \code{method}, \code{inteval},
\code{Trange}, and \code{K} are exactly the same as these in the provided
\code{object}. If \code{insert="X"} or \code{"basis"}, \code{sseq} is the
sorted sequence of all the observed time points in fitting \code{FuncompCGL} model and
all the observed time points in \code{newx}. Then interpolation is
conducted on \code{sseq}. If matrix \code{X} after integral is provided in
the \code{FuncompCGL} object, these parameters are required.
}
\examples{
df_beta = 5
p = 30
beta_C_true = matrix(0, nrow = p, ncol = df_beta)
beta_C_true[1, ] <- c(-0.5, -0.5, -0.5 , -1, -1)
beta_C_true[2, ] <- c(0.8, 0.8,  0.7,  0.6,  0.6)
beta_C_true[3, ] <- c(-0.8, -0.8 , 0.4 , 1 , 1)
beta_C_true[4, ] <- c(0.5, 0.5, -0.6  ,-0.6, -0.6)
n_train = 50
n_test = 30
k_list <- c(4,5)
Data <- Fcomp_Model(n = n_train, p = p, m = 0, intercept = TRUE,
                    SNR = 4, sigma = 3, rho_X = 0.6, rho_T = 0,
                    df_beta = df_beta, n_T = 20, obs_spar = 1, theta.add = FALSE,
                    beta_C = as.vector(t(beta_C_true)))
arg_list <- as.list(Data$call)[-1]
arg_list$n <- n_test
Test <- do.call(Fcomp_Model, arg_list)
GIC_m1 <-  GIC.FuncompCGL(y = Data$data$y, X = Data$data$Comp,
                          Zc = Data$data$Zc, intercept = Data$data$intercept,
                          k = k_list)
y_hat <- predict(GIC_m1, Znew = Test$data$Comp, Zcnew = Test$data$Zc)
predict(GIC_m1, Znew = Test$data$Comp, Zcnew = Test$data$Zc, s = NULL, k = k_list)
plot(Test$data$y, y_hat, xlab = "Observed response", ylab = "Predicted response")

}
\references{
Sun, Z., Xu, W., Cong, X., Li G. and Chen K. (2020) \emph{Log-contrast regression with
functional compositional predictors: linking preterm infant's gut microbiome trajectories
to neurobehavioral outcome}, \href{https://arxiv.org/abs/1808.02403}{https://arxiv.org/abs/1808.02403}
\emph{Annals of Applied Statistics}
}
\seealso{
\code{\link{GIC.FuncompCGL}} and \code{\link{FuncompCGL}}, and
\code{\link[=coef.GIC.FuncompCGL]{coef}} and
\code{\link[=plot.GIC.FuncompCGL]{plot}} methods for \code{"GIC.FuncompCGL"} object.
}
\author{
Zhe Sun and Kun Chen
}
