/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel.hover;

import net.infonode.gui.hover.HoverEvent;
import net.infonode.gui.hover.HoverListener;
import net.infonode.tabbedpanel.Tab;
import net.infonode.tabbedpanel.TabAdapter;
import net.infonode.tabbedpanel.TabEvent;
import net.infonode.tabbedpanel.TabRemovedEvent;
import net.infonode.tabbedpanel.TabStateChangedEvent;
import net.infonode.tabbedpanel.TabbedPanel;
import net.infonode.tabbedpanel.TabbedPanelProperties;
import net.infonode.tabbedpanel.titledtab.TitledTab;
import net.infonode.tabbedpanel.titledtab.TitledTabProperties;

public class TabbedPanelTitledTabHoverAction
implements HoverListener {
    private TabbedPanelProperties tabbedPanelProperties;
    private TitledTabProperties titledTabProperties;
    private boolean onlyHighlighted;
    private TabAdapter tabListener = new TabAdapter(){

        public void tabAdded(TabEvent tabEvent) {
            if (tabEvent.getTab() instanceof TitledTab && (!TabbedPanelTitledTabHoverAction.this.onlyHighlighted || TabbedPanelTitledTabHoverAction.this.onlyHighlighted && tabEvent.getTab().isHighlighted())) {
                ((TitledTab)tabEvent.getTab()).getProperties().addSuperObject(TabbedPanelTitledTabHoverAction.this.titledTabProperties);
            }
        }

        public void tabRemoved(TabRemovedEvent tabRemovedEvent) {
            if (tabRemovedEvent.getTab() instanceof TitledTab) {
                ((TitledTab)tabRemovedEvent.getTab()).getProperties().removeSuperObject(TabbedPanelTitledTabHoverAction.this.titledTabProperties);
            }
        }

        public void tabHighlighted(TabStateChangedEvent tabStateChangedEvent) {
            if (tabStateChangedEvent.getCurrentTab() != null && tabStateChangedEvent.getCurrentTab() instanceof TitledTab) {
                TabbedPanelTitledTabHoverAction.this.applyTitledTabProperties(tabStateChangedEvent.getTabbedPanel(), (TitledTab)tabStateChangedEvent.getCurrentTab());
            }
        }

        public void tabDehighlighted(TabStateChangedEvent tabStateChangedEvent) {
            if (tabStateChangedEvent.getPreviousTab() != null && tabStateChangedEvent.getPreviousTab() instanceof TitledTab) {
                TabbedPanelTitledTabHoverAction.this.removeTitledTabProperties(tabStateChangedEvent.getTabbedPanel(), (TitledTab)tabStateChangedEvent.getPreviousTab());
            }
        }
    };

    public TabbedPanelTitledTabHoverAction() {
        this(false);
    }

    public TabbedPanelTitledTabHoverAction(boolean bl) {
        this(new TabbedPanelProperties(), new TitledTabProperties(), bl);
    }

    public TabbedPanelTitledTabHoverAction(TabbedPanelProperties tabbedPanelProperties, TitledTabProperties titledTabProperties) {
        this(tabbedPanelProperties, titledTabProperties, false);
    }

    public TabbedPanelTitledTabHoverAction(TabbedPanelProperties tabbedPanelProperties, TitledTabProperties titledTabProperties, boolean bl) {
        this.tabbedPanelProperties = tabbedPanelProperties;
        this.titledTabProperties = titledTabProperties;
        this.onlyHighlighted = !bl;
    }

    public TitledTabProperties getTitledTabProperties() {
        return this.titledTabProperties;
    }

    public TabbedPanelProperties getTabbedPanelProperties() {
        return this.tabbedPanelProperties;
    }

    public void mouseEntered(HoverEvent hoverEvent) {
        TabbedPanel tabbedPanel = (TabbedPanel)hoverEvent.getSource();
        tabbedPanel.getProperties().addSuperObject(this.tabbedPanelProperties);
        tabbedPanel.addTabListener(this.tabListener);
        if (tabbedPanel.getHighlightedTab() != null && tabbedPanel.getHighlightedTab() instanceof TitledTab) {
            this.applyTitledTabProperties(tabbedPanel, (TitledTab)tabbedPanel.getHighlightedTab());
        } else {
            this.applyTitledTabProperties(tabbedPanel, null);
        }
    }

    public void mouseExited(HoverEvent hoverEvent) {
        TabbedPanel tabbedPanel = (TabbedPanel)hoverEvent.getSource();
        tabbedPanel.getProperties().removeSuperObject(this.tabbedPanelProperties);
        tabbedPanel.removeTabListener(this.tabListener);
        if (tabbedPanel.getHighlightedTab() != null && tabbedPanel.getHighlightedTab() instanceof TitledTab) {
            this.removeTitledTabProperties(tabbedPanel, (TitledTab)tabbedPanel.getHighlightedTab());
        } else {
            this.removeTitledTabProperties(tabbedPanel, null);
        }
    }

    private void applyTitledTabProperties(TabbedPanel tabbedPanel, TitledTab titledTab) {
        if (this.onlyHighlighted) {
            if (titledTab != null) {
                titledTab.getProperties().addSuperObject(this.titledTabProperties);
            }
        } else {
            for (int i = 0; i < tabbedPanel.getTabCount(); ++i) {
                Tab tab = tabbedPanel.getTabAt(i);
                if (!(tab instanceof TitledTab)) continue;
                ((TitledTab)tab).getProperties().addSuperObject(this.titledTabProperties);
            }
        }
    }

    private void removeTitledTabProperties(TabbedPanel tabbedPanel, TitledTab titledTab) {
        if (this.onlyHighlighted) {
            if (titledTab != null) {
                titledTab.getProperties().removeSuperObject(this.titledTabProperties);
            }
        } else {
            for (int i = 0; i < tabbedPanel.getTabCount(); ++i) {
                Tab tab = tabbedPanel.getTabAt(i);
                if (!(tab instanceof TitledTab)) continue;
                ((TitledTab)tab).getProperties().removeSuperObject(this.titledTabProperties);
            }
        }
    }
}

