/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel;

import java.awt.Color;
import java.util.HashMap;
import javax.swing.border.CompoundBorder;
import net.infonode.gui.DynamicUIManager;
import net.infonode.gui.DynamicUIManagerListener;
import net.infonode.gui.border.HighlightBorder;
import net.infonode.gui.hover.HoverListener;
import net.infonode.gui.icon.button.ArrowIcon;
import net.infonode.gui.icon.button.BorderIcon;
import net.infonode.gui.icon.button.DropDownIcon;
import net.infonode.properties.base.Property;
import net.infonode.properties.base.PropertyGroup;
import net.infonode.properties.gui.util.ButtonProperties;
import net.infonode.properties.propertymap.PropertyMap;
import net.infonode.properties.propertymap.PropertyMapContainer;
import net.infonode.properties.propertymap.PropertyMapFactory;
import net.infonode.properties.propertymap.PropertyMapGroup;
import net.infonode.properties.propertymap.PropertyMapManager;
import net.infonode.properties.propertymap.PropertyMapProperty;
import net.infonode.properties.propertymap.PropertyMapValueHandler;
import net.infonode.properties.types.BooleanProperty;
import net.infonode.properties.types.ColorProperty;
import net.infonode.properties.types.DirectionProperty;
import net.infonode.properties.types.FloatProperty;
import net.infonode.properties.types.HoverListenerProperty;
import net.infonode.properties.types.IntegerProperty;
import net.infonode.tabbedpanel.TabAreaComponentsProperties;
import net.infonode.tabbedpanel.TabAreaProperties;
import net.infonode.tabbedpanel.TabAreaVisiblePolicy;
import net.infonode.tabbedpanel.TabDepthOrderPolicy;
import net.infonode.tabbedpanel.TabDepthOrderPolicyProperty;
import net.infonode.tabbedpanel.TabDropDownListVisiblePolicy;
import net.infonode.tabbedpanel.TabDropDownListVisiblePolicyProperty;
import net.infonode.tabbedpanel.TabLayoutPolicy;
import net.infonode.tabbedpanel.TabLayoutPolicyProperty;
import net.infonode.tabbedpanel.TabSelectTrigger;
import net.infonode.tabbedpanel.TabSelectTriggerProperty;
import net.infonode.tabbedpanel.TabbedPanelButtonProperties;
import net.infonode.tabbedpanel.TabbedPanelContentPanelProperties;
import net.infonode.tabbedpanel.TabbedPanelDefaultButtonFactories;
import net.infonode.tabbedpanel.TabbedPanelHoverPolicy;
import net.infonode.tabbedpanel.TabbedPanelHoverPolicyProperty;
import net.infonode.tabbedpanel.TabbedUIDefaults;
import net.infonode.tabbedpanel.border.OpenContentBorder;
import net.infonode.tabbedpanel.border.TabAreaLineBorder;
import net.infonode.util.ArrayUtil;
import net.infonode.util.Direction;

public class TabbedPanelProperties
extends PropertyMapContainer {
    public static final PropertyMapGroup PROPERTIES = new PropertyMapGroup("Tabbed Panel Properties", "Properties for the TabbedPanel class.");
    public static final BooleanProperty TAB_REORDER_ENABLED = new BooleanProperty((PropertyGroup)PROPERTIES, "Tab Reorder Enabled", "Tab reorder enabled or disabled", PropertyMapValueHandler.INSTANCE);
    public static final IntegerProperty ABORT_DRAG_KEY = IntegerProperty.createPositive(PROPERTIES, "Abort Drag Key Code", "Key code for aborting drag", 3, PropertyMapValueHandler.INSTANCE);
    public static final TabLayoutPolicyProperty TAB_LAYOUT_POLICY = new TabLayoutPolicyProperty((PropertyGroup)PROPERTIES, "Layout Policy", "Tab layout in tab area", PropertyMapValueHandler.INSTANCE);
    public static final TabDropDownListVisiblePolicyProperty TAB_DROP_DOWN_LIST_VISIBLE_POLICY = new TabDropDownListVisiblePolicyProperty((PropertyGroup)PROPERTIES, "Tab Drop Down List Visible Policy", "Determins when a drop down list with tabs should be visible in the tab area", PropertyMapValueHandler.INSTANCE);
    public static final TabSelectTriggerProperty TAB_SELECT_TRIGGER = new TabSelectTriggerProperty((PropertyGroup)PROPERTIES, "Tab Select Trigger", "Determins when a tab should be selected", PropertyMapValueHandler.INSTANCE);
    public static final IntegerProperty TAB_SCROLLING_OFFSET = IntegerProperty.createPositive(PROPERTIES, "Scroll Offset", "Number of pixels to be shown for the last scrolled tab", 3, PropertyMapValueHandler.INSTANCE);
    public static final BooleanProperty ENSURE_SELECTED_VISIBLE = new BooleanProperty((PropertyGroup)PROPERTIES, "Ensure Selected Visible", "Upon select, the selected tab will be scrolled into the visible area.", PropertyMapValueHandler.INSTANCE);
    public static final DirectionProperty TAB_AREA_ORIENTATION = new DirectionProperty((PropertyGroup)PROPERTIES, "Tab Area Orientation", "Tab area's orientation relative to the content area.", PropertyMapValueHandler.INSTANCE);
    public static final IntegerProperty TAB_SPACING = new IntegerProperty(PROPERTIES, "Tab Spacing", "Number of pixels between tabs in tab area. A negative value will result in tab overlapping.", Integer.MIN_VALUE, Integer.MAX_VALUE, 3, PropertyMapValueHandler.INSTANCE);
    public static final TabDepthOrderPolicyProperty TAB_DEPTH_ORDER = new TabDepthOrderPolicyProperty((PropertyGroup)PROPERTIES, "Tab Depth Order", "Tabs will overlap when tab spacing is negative. Depth order tells if first tab should be the top most and the other tabs in descending order or if the first tab should be bottom most and the other tabs in ascending order.", PropertyMapValueHandler.INSTANCE);
    public static final BooleanProperty AUTO_SELECT_TAB = new BooleanProperty((PropertyGroup)PROPERTIES, "Auto Select Tab", "When enabled the first tab that i added will be selected automatically. If the selected tab is removed then the tab next to the removed tab will be selected automatically.", PropertyMapValueHandler.INSTANCE);
    public static final BooleanProperty HIGHLIGHT_PRESSED_TAB = new BooleanProperty((PropertyGroup)PROPERTIES, "Highlight Pressed Tab", "If true the tab pressed with the mouse will be highlighted, otherwise it remains unchanged.", PropertyMapValueHandler.INSTANCE);
    public static final BooleanProperty TAB_DESELECTABLE = new BooleanProperty((PropertyGroup)PROPERTIES, "Tab Deselectable", "When enabled the selected tab can be deselected by clicking on it.", PropertyMapValueHandler.INSTANCE);
    public static final PropertyMapProperty CONTENT_PANEL_PROPERTIES = new PropertyMapProperty((PropertyGroup)PROPERTIES, "Content Panel Properties", "Content panel properties.", TabbedPanelContentPanelProperties.PROPERTIES);
    public static final PropertyMapProperty TAB_AREA_PROPERTIES = new PropertyMapProperty((PropertyGroup)PROPERTIES, "Tab Area Properties", "Tab area properties.", TabAreaProperties.PROPERTIES);
    public static final PropertyMapProperty TAB_AREA_COMPONENTS_PROPERTIES = new PropertyMapProperty((PropertyGroup)PROPERTIES, "Tab Area Components Properties", "Tab area components properties.", TabAreaComponentsProperties.PROPERTIES);
    public static final PropertyMapProperty BUTTON_PROPERTIES = new PropertyMapProperty((PropertyGroup)PROPERTIES, "Tabbed Panel Button Properties", "Tabbed panel button properties.", TabbedPanelButtonProperties.PROPERTIES);
    public static final BooleanProperty SHADOW_ENABLED = new BooleanProperty((PropertyGroup)PROPERTIES, "Shadow Enabled", "Indicates that a shadow is painted for the selected tab and the content panel.\nThe shadow is partially painted using alpha transparency which can be slow on some systems.", PropertyMapValueHandler.INSTANCE);
    public static final HoverListenerProperty HOVER_LISTENER = new HoverListenerProperty((PropertyGroup)PROPERTIES, "Hover Listener", "Hover Listener to be used for tracking mouse hovering over the tabbed panel.", PropertyMapValueHandler.INSTANCE);
    public static final TabbedPanelHoverPolicyProperty HOVER_POLICY = new TabbedPanelHoverPolicyProperty((PropertyGroup)PROPERTIES, "Hover Policy", "Policy for when the Tabbed Panel is considerd hovered by the mouse.", PropertyMapValueHandler.INSTANCE);
    public static final BooleanProperty PAINT_TAB_AREA_SHADOW = new BooleanProperty((PropertyGroup)PROPERTIES, "Paint Tab Area Shadow", "Paint a shadow for the tab area. If this property is set to false a shadow is painted for the highlighted tab and the tab area components panel.", PropertyMapValueHandler.INSTANCE);
    public static final IntegerProperty SHADOW_SIZE = IntegerProperty.createPositive(PROPERTIES, "Shadow Size", "The size of the tab shadow.", 2, PropertyMapValueHandler.INSTANCE);
    public static final IntegerProperty SHADOW_BLEND_AREA_SIZE = IntegerProperty.createPositive(PROPERTIES, "Shadow Blend Size", "The size of the tab shadow blend area.", 2, PropertyMapValueHandler.INSTANCE);
    public static final ColorProperty SHADOW_COLOR = new ColorProperty((PropertyGroup)PROPERTIES, "Shadow Color", "The color of the shadow.", PropertyMapValueHandler.INSTANCE);
    public static final FloatProperty SHADOW_STRENGTH = new FloatProperty(PROPERTIES, "Shadow Strength", "The strength of the shadow. 0 means the shadow color is the same as the backgound color, 1 means the shadow color is '" + SHADOW_COLOR + "'.", PropertyMapValueHandler.INSTANCE, 0.0f, 1.0f);
    public static final Property[] FUNCTIONAL_PROPERTIES = new Property[]{TAB_REORDER_ENABLED, ABORT_DRAG_KEY, TAB_LAYOUT_POLICY, ENSURE_SELECTED_VISIBLE, AUTO_SELECT_TAB, TAB_DESELECTABLE, TAB_SELECT_TRIGGER, HOVER_POLICY};
    public static final Property[] SHADOW_PROPERTIES = new Property[]{SHADOW_ENABLED, SHADOW_SIZE, SHADOW_BLEND_AREA_SIZE, SHADOW_COLOR, SHADOW_STRENGTH};
    public static final Property[] TABS_VISUAL_PROPERTIES = new Property[]{TAB_SCROLLING_OFFSET, TAB_SPACING, TAB_AREA_ORIENTATION, TAB_AREA_PROPERTIES, TAB_AREA_COMPONENTS_PROPERTIES, TAB_LAYOUT_POLICY, CONTENT_PANEL_PROPERTIES, TAB_DROP_DOWN_LIST_VISIBLE_POLICY};
    public static final Property[] VISUAL_PROPERTIES = (Property[])ArrayUtil.append(TABS_VISUAL_PROPERTIES, SHADOW_PROPERTIES, new Property[TABS_VISUAL_PROPERTIES.length + SHADOW_PROPERTIES.length]);
    private static final TabbedPanelProperties DEFAULT_PROPERTIES = new TabbedPanelProperties(PROPERTIES.getDefaultMap());

    public static TabbedPanelProperties getDefaultProperties() {
        return new TabbedPanelProperties(DEFAULT_PROPERTIES);
    }

    private static void updateVisualProperties() {
        PropertyMapManager.runBatch(new Runnable(){

            public void run() {
                DEFAULT_PROPERTIES.getContentPanelProperties().getComponentProperties().setBorder(new OpenContentBorder(TabbedUIDefaults.getDarkShadow(), TabbedUIDefaults.getHighlight())).setInsets(TabbedUIDefaults.getContentAreaInsets()).setBackgroundColor(TabbedUIDefaults.getContentAreaBackground());
                DEFAULT_PROPERTIES.getContentPanelProperties().getShapedPanelProperties().setOpaque(true);
                DEFAULT_PROPERTIES.getTabAreaComponentsProperties().setStretchEnabled(false).getComponentProperties().setBorder(new CompoundBorder(new TabAreaLineBorder(TabbedUIDefaults.getDarkShadow()), new HighlightBorder(false, TabbedUIDefaults.getHighlight()))).setBackgroundColor(TabbedUIDefaults.getContentAreaBackground());
                DEFAULT_PROPERTIES.getTabAreaComponentsProperties().getShapedPanelProperties().setOpaque(true);
                DEFAULT_PROPERTIES.getTabAreaProperties().getShapedPanelProperties().setOpaque(false);
            }
        });
    }

    private static void updateFunctionalProperties() {
        DEFAULT_PROPERTIES.setTabReorderEnabled(false).setAbortDragKey(27).setTabLayoutPolicy(TabLayoutPolicy.SCROLLING).setTabDropDownListVisiblePolicy(TabDropDownListVisiblePolicy.NEVER).setTabSelectTrigger(TabSelectTrigger.MOUSE_PRESS).setTabScrollingOffset(10).setTabSpacing(-1).setTabDepthOrderPolicy(TabDepthOrderPolicy.DESCENDING).setEnsureSelectedTabVisible(false).setTabAreaOrientation(Direction.UP).setAutoSelectTab(true).setHighlightPressedTab(true).setHoverPolicy(TabbedPanelHoverPolicy.NO_HOVERED_CHILD).setShadowEnabled(false).setShadowSize(3).setShadowBlendAreaSize(2).setShadowColor(Color.BLACK).setShadowStrength(0.4f);
        DEFAULT_PROPERTIES.getTabAreaProperties().setTabAreaVisiblePolicy(TabAreaVisiblePolicy.ALWAYS);
        HashMap<Direction, ButtonProperties> hashMap = new HashMap<Direction, ButtonProperties>();
        hashMap.put(Direction.DOWN, DEFAULT_PROPERTIES.getButtonProperties().getScrollDownButtonProperties());
        hashMap.put(Direction.UP, DEFAULT_PROPERTIES.getButtonProperties().getScrollUpButtonProperties());
        hashMap.put(Direction.RIGHT, DEFAULT_PROPERTIES.getButtonProperties().getScrollRightButtonProperties());
        hashMap.put(Direction.LEFT, DEFAULT_PROPERTIES.getButtonProperties().getScrollLeftButtonProperties());
        int n = TabbedUIDefaults.getButtonIconSize();
        Direction[] directionArray = Direction.getDirections();
        for (int i = 0; i < directionArray.length; ++i) {
            ArrowIcon arrowIcon = new ArrowIcon(n - 2, directionArray[i], false);
            arrowIcon.setShadowEnabled(false);
            ((ButtonProperties)hashMap.get(directionArray[i])).setFactory(TabbedPanelDefaultButtonFactories.getScrollDownButtonFactory()).setIcon(new ArrowIcon(n, directionArray[i])).setDisabledIcon(new BorderIcon(arrowIcon, 1));
        }
        DEFAULT_PROPERTIES.getButtonProperties().getTabDropDownListButtonProperties().setFactory(TabbedPanelDefaultButtonFactories.getScrollDownButtonFactory()).setIcon(new DropDownIcon(Color.black, TabbedUIDefaults.getButtonIconSize(), Direction.DOWN)).setDisabledIcon(null);
    }

    public TabbedPanelProperties() {
        super(PROPERTIES);
    }

    public TabbedPanelProperties(PropertyMap propertyMap) {
        super(propertyMap);
    }

    public TabbedPanelProperties(TabbedPanelProperties tabbedPanelProperties) {
        super(PropertyMapFactory.create(tabbedPanelProperties.getMap()));
    }

    public TabbedPanelProperties addSuperObject(TabbedPanelProperties tabbedPanelProperties) {
        this.getMap().addSuperMap(tabbedPanelProperties.getMap());
        return this;
    }

    public TabbedPanelProperties removeSuperObject() {
        this.getMap().removeSuperMap();
        return this;
    }

    public TabbedPanelProperties removeSuperObject(TabbedPanelProperties tabbedPanelProperties) {
        this.getMap().removeSuperMap(tabbedPanelProperties.getMap());
        return this;
    }

    public TabbedPanelProperties replaceSuperObject(TabbedPanelProperties tabbedPanelProperties, TabbedPanelProperties tabbedPanelProperties2) {
        this.getMap().replaceSuperMap(tabbedPanelProperties.getMap(), tabbedPanelProperties2.getMap());
        return this;
    }

    public TabbedPanelProperties setShadowStrength(float f) {
        SHADOW_STRENGTH.set(this.getMap(), f);
        return this;
    }

    public TabbedPanelProperties setShadowBlendAreaSize(int n) {
        SHADOW_BLEND_AREA_SIZE.set(this.getMap(), n);
        return this;
    }

    public TabbedPanelProperties setShadowSize(int n) {
        SHADOW_SIZE.set(this.getMap(), n);
        return this;
    }

    public TabbedPanelProperties setShadowColor(Color color) {
        SHADOW_COLOR.set(this.getMap(), color);
        return this;
    }

    public TabbedPanelProperties setShadowEnabled(boolean bl) {
        SHADOW_ENABLED.set(this.getMap(), bl);
        return this;
    }

    public TabbedPanelProperties setAutoSelectTab(boolean bl) {
        AUTO_SELECT_TAB.set(this.getMap(), bl);
        return this;
    }

    public TabbedPanelProperties setTabDeselectable(boolean bl) {
        TAB_DESELECTABLE.set(this.getMap(), bl);
        return this;
    }

    public TabbedPanelProperties setEnsureSelectedTabVisible(boolean bl) {
        ENSURE_SELECTED_VISIBLE.set(this.getMap(), bl);
        return this;
    }

    public TabbedPanelProperties setTabScrollingOffset(int n) {
        TAB_SCROLLING_OFFSET.set(this.getMap(), n);
        return this;
    }

    public TabbedPanelProperties setTabReorderEnabled(boolean bl) {
        TAB_REORDER_ENABLED.set(this.getMap(), bl);
        return this;
    }

    public TabbedPanelProperties setHighlightPressedTab(boolean bl) {
        HIGHLIGHT_PRESSED_TAB.set(this.getMap(), bl);
        return this;
    }

    public TabbedPanelProperties setAbortDragKey(int n) {
        ABORT_DRAG_KEY.set(this.getMap(), n);
        return this;
    }

    public TabbedPanelProperties setTabLayoutPolicy(TabLayoutPolicy tabLayoutPolicy) {
        TAB_LAYOUT_POLICY.set(this.getMap(), tabLayoutPolicy);
        return this;
    }

    public TabbedPanelProperties setTabDropDownListVisiblePolicy(TabDropDownListVisiblePolicy tabDropDownListVisiblePolicy) {
        TAB_DROP_DOWN_LIST_VISIBLE_POLICY.set(this.getMap(), tabDropDownListVisiblePolicy);
        return this;
    }

    public TabbedPanelProperties setTabSelectTrigger(TabSelectTrigger tabSelectTrigger) {
        TAB_SELECT_TRIGGER.set(this.getMap(), tabSelectTrigger);
        return this;
    }

    public TabbedPanelProperties setTabAreaOrientation(Direction direction) {
        TAB_AREA_ORIENTATION.set(this.getMap(), direction);
        return this;
    }

    public TabbedPanelProperties setTabSpacing(int n) {
        TAB_SPACING.set(this.getMap(), n);
        return this;
    }

    public TabbedPanelProperties setTabDepthOrderPolicy(TabDepthOrderPolicy tabDepthOrderPolicy) {
        TAB_DEPTH_ORDER.set(this.getMap(), tabDepthOrderPolicy);
        return this;
    }

    public float getShadowStrength() {
        return SHADOW_STRENGTH.get(this.getMap());
    }

    public int getShadowBlendAreaSize() {
        return SHADOW_BLEND_AREA_SIZE.get(this.getMap());
    }

    public int getShadowSize() {
        return SHADOW_SIZE.get(this.getMap());
    }

    public Color getShadowColor() {
        return SHADOW_COLOR.get(this.getMap());
    }

    public boolean getShadowEnabled() {
        return SHADOW_ENABLED.get(this.getMap());
    }

    public boolean getAutoSelectTab() {
        return AUTO_SELECT_TAB.get(this.getMap());
    }

    public boolean getHighlightPressedTab() {
        return HIGHLIGHT_PRESSED_TAB.get(this.getMap());
    }

    public boolean getTabDeselectable() {
        return TAB_DESELECTABLE.get(this.getMap());
    }

    public boolean getEnsureSelectedTabVisible() {
        return ENSURE_SELECTED_VISIBLE.get(this.getMap());
    }

    public boolean getPaintTabAreaShadow() {
        return PAINT_TAB_AREA_SHADOW.get(this.getMap());
    }

    public TabbedPanelProperties setPaintTabAreaShadow(boolean bl) {
        PAINT_TAB_AREA_SHADOW.set(this.getMap(), bl);
        return this;
    }

    public int getTabScrollingOffset() {
        return TAB_SCROLLING_OFFSET.get(this.getMap());
    }

    public boolean getTabReorderEnabled() {
        return TAB_REORDER_ENABLED.get(this.getMap());
    }

    public int getAbortDragKey() {
        return ABORT_DRAG_KEY.get(this.getMap());
    }

    public TabLayoutPolicy getTabLayoutPolicy() {
        return TAB_LAYOUT_POLICY.get(this.getMap());
    }

    public TabDropDownListVisiblePolicy getTabDropDownListVisiblePolicy() {
        return TAB_DROP_DOWN_LIST_VISIBLE_POLICY.get(this.getMap());
    }

    public TabSelectTrigger getTabSelectTrigger() {
        return TAB_SELECT_TRIGGER.get(this.getMap());
    }

    public Direction getTabAreaOrientation() {
        return TAB_AREA_ORIENTATION.get(this.getMap());
    }

    public int getTabSpacing() {
        return TAB_SPACING.get(this.getMap());
    }

    public TabDepthOrderPolicy getTabDepthOrderPolicy() {
        return TAB_DEPTH_ORDER.get(this.getMap());
    }

    public TabbedPanelProperties setHoverListener(HoverListener hoverListener) {
        HOVER_LISTENER.set(this.getMap(), hoverListener);
        return this;
    }

    public HoverListener getHoverListener() {
        return HOVER_LISTENER.get(this.getMap());
    }

    public TabbedPanelProperties setHoverPolicy(TabbedPanelHoverPolicy tabbedPanelHoverPolicy) {
        HOVER_POLICY.set(this.getMap(), tabbedPanelHoverPolicy);
        return this;
    }

    public TabbedPanelHoverPolicy getHoverPolicy() {
        return HOVER_POLICY.get(this.getMap());
    }

    public TabbedPanelContentPanelProperties getContentPanelProperties() {
        return new TabbedPanelContentPanelProperties(CONTENT_PANEL_PROPERTIES.get(this.getMap()));
    }

    public TabAreaProperties getTabAreaProperties() {
        return new TabAreaProperties(TAB_AREA_PROPERTIES.get(this.getMap()));
    }

    public TabAreaComponentsProperties getTabAreaComponentsProperties() {
        return new TabAreaComponentsProperties(TAB_AREA_COMPONENTS_PROPERTIES.get(this.getMap()));
    }

    public TabbedPanelButtonProperties getButtonProperties() {
        return new TabbedPanelButtonProperties(BUTTON_PROPERTIES.get(this.getMap()));
    }

    static {
        DynamicUIManager.getInstance().addListener(new DynamicUIManagerListener(){

            public void lookAndFeelChanged() {
                TabbedPanelProperties.updateVisualProperties();
            }

            public void propertiesChanged() {
                TabbedPanelProperties.updateVisualProperties();
            }

            public void propertiesChanging() {
            }

            public void lookAndFeelChanging() {
            }
        });
        TabbedPanelProperties.updateVisualProperties();
        TabbedPanelProperties.updateFunctionalProperties();
    }
}

