/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.action;

import java.io.ObjectStreamException;
import javax.swing.Icon;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.TabWindow;
import net.infonode.docking.action.DockingWindowAction;
import net.infonode.docking.util.DockingUtil;
import net.infonode.gui.icon.button.RestoreIcon;

public final class RestoreParentWindowAction
extends DockingWindowAction {
    private static final long serialVersionUID = 1L;
    public static final RestoreParentWindowAction INSTANCE = new RestoreParentWindowAction();
    private static final Icon icon = new RestoreIcon(10);

    private RestoreParentWindowAction() {
    }

    public String getName() {
        return "Restore";
    }

    public boolean isPerformable(DockingWindow dockingWindow) {
        if (dockingWindow.isMinimized() && dockingWindow.isRestorable()) {
            return true;
        }
        TabWindow tabWindow = DockingUtil.getTabWindowFor(dockingWindow);
        return tabWindow != null && tabWindow.isMaximized() && tabWindow.isRestorable();
    }

    public void perform(DockingWindow dockingWindow) {
        if (dockingWindow != null && dockingWindow.isMinimized()) {
            RestoreParentWindowAction.restore(dockingWindow);
        } else {
            TabWindow tabWindow = DockingUtil.getTabWindowFor(dockingWindow);
            if (tabWindow != null && tabWindow.isMaximized()) {
                RestoreParentWindowAction.restore(tabWindow);
            }
        }
    }

    public Icon getIcon() {
        return icon;
    }

    private static void restore(DockingWindow dockingWindow) {
        if (dockingWindow != null && dockingWindow.isRestorable()) {
            dockingWindow.restore();
        }
    }

    protected Object readResolve() throws ObjectStreamException {
        return INSTANCE;
    }
}

