% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Utility.R
\name{Replace_Missing}
\alias{Replace_Missing}
\title{Automatically assigns missing values in listed columns}
\usage{
Replace_Missing(df, name_list, msv, verbose = FALSE)
}
\arguments{
\item{df}{a data.table containing the columns of interest}

\item{name_list}{vector of string column names to check}

\item{msv}{value to replace na with, same used for every column used}

\item{verbose}{integer valued 0-4 controlling what information is printed to the terminal. Each level includes the lower levels. 0: silent, 1: errors printed, 2: warnings printed, 3: notes printed, 4: debug information printed. Errors are situations that stop the regression, warnings are situations that assume default values that the user might not have intended, notes provide information on regression progress, and debug prints out C++ progress and intermediate results. The default level is 2 and True/False is converted to 3/0.}
}
\value{
returns a filled datatable
}
\description{
\code{Replace_Missing} checks each column and fills in NA values
}
\examples{
library(data.table)
## basic example code reproduced from the starting-description vignette

df <- data.table::data.table("UserID"=c(112, 114, 213, 214, 115, 116, 117),
           "Starting_Age"=c(18,  20,  18,  19,  21,  20,  18),
             "Ending_Age"=c(30,  45,  NA,  47,  36,  NA,  55),
          "Cancer_Status"=c(0,   0,   1,   0,   1,   0,   0))
df <- Replace_Missing(df, c("Starting_Age","Ending_Age"), 70)
}
\seealso{
Other Data Cleaning Functions: 
\code{\link{Check_Dupe_Columns}()},
\code{\link{Check_Trunc}()},
\code{\link{Check_Verbose}()},
\code{\link{Correct_Formula_Order}()},
\code{\link{Date_Shift}()},
\code{\link{Def_Control}()},
\code{\link{Def_Control_Guess}()},
\code{\link{Def_model_control}()},
\code{\link{Def_modelform_fix}()},
\code{\link{Joint_Multiple_Events}()},
\code{\link{Time_Since}()},
\code{\link{factorize}()},
\code{\link{factorize_par}()},
\code{\link{gen_time_dep}()},
\code{\link{interact_them}()}
}
\concept{Data Cleaning Functions}
