% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RcppExports.R
\name{Calc_Change_Basic}
\alias{Calc_Change_Basic}
\title{Utility function to calculate the change to make each iteration, with basic model
\code{Calc_Change_Basic} Called to update the parameter changes, Uses log-likelihoods and control parameters, Applies newton steps and change limitations}
\usage{
Calc_Change_Basic(
  double_step,
  nthreads,
  totalnum,
  der_iden,
  dbeta_cap,
  lr,
  abs_max,
  Ll,
  Lld,
  Lldd,
  dbeta,
  change_all,
  KeepConstant,
  debugging
)
}
\arguments{
\item{double_step}{controls the step calculation, 0 for independent changes, 1 for solving b=Ax with complete matrices}

\item{nthreads}{number of threads available}

\item{totalnum}{total number of parameters}

\item{der_iden}{subterm number for derivative tests}

\item{dbeta_cap}{learning rate for newton step toward 0 log-likelihood}

\item{lr}{learning rate for newton step toward 0 derivative}

\item{abs_max}{Maximum allowed parameter change}

\item{Ll}{Log-likelihood vector}

\item{Lld}{Log-likelihood first derivative matrix}

\item{Lldd}{Log-likelihood second derivative matrix}

\item{dbeta}{parameter change vector}

\item{change_all}{boolean if every parameter is being updated}

\item{KeepConstant}{binary vector to identify constant parameters}

\item{debugging}{additional boolean for verbosity in testing}
}
\value{
Updates matrices in place: parameter change matrix
}
\description{
Utility function to calculate the change to make each iteration, with basic model
\code{Calc_Change_Basic} Called to update the parameter changes, Uses log-likelihoods and control parameters, Applies newton steps and change limitations
}
