% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CohortConstruction.R
\name{generateCohortSet}
\alias{generateCohortSet}
\title{Generate a set of cohorts}
\usage{
generateCohortSet(
  connectionDetails = NULL,
  connection = NULL,
  cdmDatabaseSchema,
  tempEmulationSchema = getOption("sqlRenderTempEmulationSchema"),
  cohortDatabaseSchema = cdmDatabaseSchema,
  cohortTableNames = getCohortTableNames(),
  cohortDefinitionSet = NULL,
  stopOnError = TRUE,
  incremental = FALSE,
  incrementalFolder = NULL
)
}
\arguments{
\item{connectionDetails}{An object of type \code{connectionDetails} as created using the
\code{\link[DatabaseConnector]{createConnectionDetails}} function in the
DatabaseConnector package. Can be left NULL if \code{connection} is
provided.}

\item{connection}{An object of type \code{connection} as created using the
\code{\link[DatabaseConnector]{connect}} function in the
DatabaseConnector package. Can be left NULL if \code{connectionDetails}
is provided, in which case a new connection will be opened at the start
of the function, and closed when the function finishes.}

\item{cdmDatabaseSchema}{Schema name where your patient-level data in OMOP CDM format resides.
Note that for SQL Server, this should include both the database and
schema name, for example 'cdm_data.dbo'.}

\item{tempEmulationSchema}{Some database platforms like Oracle and Impala do not truly support
temp tables. To emulate temp tables, provide a schema with write
privileges where temp tables can be created.}

\item{cohortDatabaseSchema}{Schema name where your cohort tables reside. Note that for SQL Server,
this should include both the database and schema name, for example
'scratch.dbo'.}

\item{cohortTableNames}{The names of the cohort tables. See \code{\link{getCohortTableNames}}
for more details.}

\item{cohortDefinitionSet}{The \code{cohortDefinitionSet} argument must be a data frame with 
the following columns: \describe{
\item{cohortId}{The unique integer identifier of the cohort} 
\item{cohortName}{The cohort's name}
\item{sql}{The OHDSI-SQL used to generate the cohort}}
Optionally, this data frame may contain: \describe{
\item{json}{The Circe JSON representation of the cohort}}}

\item{stopOnError}{If an error happens while generating one of the cohorts in the
cohortDefinitionSet, should we stop processing the other
cohorts? The default is TRUE; when set to FALSE, failures will
be identified in the return value from this function.}

\item{incremental}{Create only cohorts that haven't been created before?}

\item{incrementalFolder}{If \code{incremental = TRUE}, specify a folder where records are
kept of which definition has been executed.}
}
\value{
A data.frame consisting of the following columns:
\describe{
   \item{cohortId}{The unique integer identifier of the cohort}
   \item{cohortName}{The cohort's name}
   \item{generationStatus}{The status of the generation task which may be one of the following:
          \describe{
               \item{COMPLETE}{The generation completed successfully}
               \item{FAILED}{The generation failed (see logs for details)}
               \item{SKIPPED}{If using incremental == 'TRUE', this status indicates
                              that the cohort's generation was skipped since it
                              was previously completed.}
          }}
   \item{startTime}{The start time of the cohort generation. If the generationStatus == 'SKIPPED', the startTime will be NA.}
   \item{endTime}{The end time of the cohort generation. If the generationStatus == 'FAILED', the endTime will be the time of the failure.
                  If the generationStatus == 'SKIPPED', endTime will be NA.}
   }
}
\description{
This function generates a set of cohorts in the cohort table.
}
