% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/requireDateRange.R
\name{trimToDateRange}
\alias{trimToDateRange}
\title{Trim cohort dates to be within a date range}
\usage{
trimToDateRange(
  cohort,
  dateRange,
  cohortId = NULL,
  startDate = "cohort_start_date",
  endDate = "cohort_end_date",
  name = tableName(cohort),
  .softValidation = FALSE
)
}
\arguments{
\item{cohort}{A cohort table in a cdm reference.}

\item{dateRange}{A window of time during which the start and end date must
have been observed.}

\item{cohortId}{Vector identifying which cohorts to modify
(cohort_definition_id or cohort_name). If NULL, all cohorts will be
used; otherwise, only the specified cohorts will be modified, and the
rest will remain unchanged.}

\item{startDate}{Variable with earliest date.}

\item{endDate}{Variable with latest date.}

\item{name}{Name of the new cohort table created in the cdm object.}

\item{.softValidation}{Whether to perform a soft validation of consistency.
If set to FALSE four additional checks will be performed: 1) a check that
cohort end date is not before cohort start date,  2) a check that there
are no missing values in required columns, 3) a check that cohort duration is
all within observation period, and 4) that there are no overlapping
cohort entries}
}
\value{
The cohort table with record timings updated to only be within the
date range. Any records with all time outside of the range will have
been dropped.
}
\description{
\code{trimToDateRange()} resets the cohort start and end date based on the
specified date range.
}
\examples{
\donttest{
library(CohortConstructor)
cdm <- mockCohortConstructor()
cdm$cohort1 |>
  trimToDateRange(startDate = "cohort_start_date",
                  endDate = "cohort_end_date",
                  dateRange = as.Date(c("2015-01-01",
                                        "2015-12-31")))
}
}
