% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCharacteristics.R
\name{plotCharacteristics}
\alias{plotCharacteristics}
\title{Create a ggplot from the output of summariseCharacteristics.
`r lifecycle::badge("experimental")`}
\usage{
plotCharacteristics(
  data,
  x = "variable_name",
  plotStyle = "barplot",
  facet = NULL,
  colour = NULL,
  colourName = NULL,
  .options = list()
)
}
\arguments{
\item{data}{output of summariseCharacteristics.}

\item{x}{what to plot on x axis, default as variable_name column. Has to be a column in data.}

\item{plotStyle}{Now allows boxplot or barplot only.}

\item{facet}{Variables to facet by}

\item{colour}{column in data to color by.}

\item{colourName}{Colour legend name}

\item{.options}{Additional plotting options.}
}
\value{
A ggplot.
}
\description{
Create a ggplot from the output of summariseCharacteristics.
`r lifecycle::badge("experimental")`
}
\examples{
\donttest{
library(CohortCharacteristics)
library(dplyr)

cdm <- mockCohortCharacteristics()

results <- summariseCharacteristics(
  cohort = cdm$cohort1,
  ageGroup = list(c(0, 19), c(20, 39), c(40, 59), c(60, 79), c(80, 150)),
  tableIntersectCount = list(
    tableName = "visit_occurrence", window = c(-365, -1)
  ),
  cohortIntersectFlag = list(
    targetCohortTable = "cohort2", window = c(-365, -1)
  )
)

results |>
  filter(
    variable_name == "Cohort2 flag -365 to -1",
    estimate_name == "percentage"
  ) |>
  plotCharacteristics(
    plotStyle = "barplot",
    colour = "variable_level",
    x = "variable_level",
    facet = c(
      "cdm_name",
      "group_level",
      "strata_level"
    )
  )

mockDisconnect(cdm = cdm)
}
}
