% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotLargeScaleCharacteristics.R
\name{plotLargeScaleCharacteristics}
\alias{plotLargeScaleCharacteristics}
\title{create a ggplot from the output of summariseLargeScaleCharacteristics.}
\usage{
plotLargeScaleCharacteristics(
  data,
  position = "horizontal",
  splitStrata = FALSE,
  facet = NULL,
  colorVars = "variable_level"
)
}
\arguments{
\item{data}{output of summariseLargeScaleCharacteristics().}

\item{position}{if set to *horizontal* the horizontal axis will plot "variable_name" column and the vertical axis "estimate_value" column.
If *vertical*, axis will be the other way around.}

\item{splitStrata}{boolean variable (TRUE/FALSE)}

\item{facet}{columns in data to facet. If the facet position wants to be specified, use the formula class for the input
(e.g., strata + table_name ~ group_level + cdm_name). Variables before "~" will be facet by on horizontal axis, whereas those after "~" on vertical axis.
Character format is also allowed (e.g., c("strata","table_name","group_level","cdm_name")).
Only the following columns are allowed to be facet by: c("cdm_name", "group_level", "strata_level", "variable_level", "strata", "table_name").
If splitStrata = TRUE, strata levels are also allowed.}

\item{colorVars}{column in data to color by. Only the following columns are allowed to be used: c("cdm_name", "group_level", "strata_level", "variable_level", "strata", "table_name").
If splitStrata = TRUE, strata levels are also allowed.}
}
\value{
A ggplot.
}
\description{
`r lifecycle::badge("experimental")`
}
\examples{
\donttest{
library(CohortCharacteristics)
library(DrugUtilisation)
cdm <- DrugUtilisation::mockDrugUtilisation()

lsc <- CohortCharacteristics::summariseLargeScaleCharacteristics(cdm$cohort1,
  eventInWindow = "condition_occurrence", minimumFrequency = 0.05
)
plotLargeScaleCharacteristics(
  data = lsc,
  position = "horizontal",
  facet = NULL,
  splitStrata = TRUE,
  colorVars = NULL
)
CDMConnector::cdmDisconnect(cdm = cdm)
}

}
