% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lsecond.R
\name{lsecond}
\alias{lsecond}
\alias{dlsecond}
\alias{plsecond}
\alias{qlsecond}
\title{Lambda second distribution or the non-central, non-standard, Lambda distribution.}
\usage{
plsecond(delta, n, d, rho) 
dlsecond(delta, n, d, rho) 
qlsecond(p,     n, d, rho)
}
\arguments{
\item{delta}{the parameter of the population whose probability is to assess;}

\item{n}{the sample size n}

\item{d}{the observed d_p of the sample;}

\item{rho}{the population correlation}

\item{p}{the probability from which a quantile is requested}
}
\value{
\if{html}{\out{<div class="sourceCode">}}\preformatted{     The probability or quantile of a Lambda'' distribution.
}\if{html}{\out{</div>}}
}
\description{
This distribution was introduced in \insertCite{c22b;textual}{CohensdpLibrary} as the
exact solution to the predictive distribution of the Cohen's dp in repeated-measure
design. A more elegant notation was provided in \insertCite{l22;textual}{CohensdpLibrary}.
It is the dual of the t" distribution, the sampling distribution of dp in repeated-measure
design introduced in \insertCite{c22a;textual}{CohensdpLibrary}.
}
\details{
lsecond are {p,d,q} functions that compute the Lambda-second (L") distribution. This
distribution is an generalization of the lambda-prime distribution
\insertCite{l99}{CohensdpLibrary}.

Note that the parameters are the raw sample size n, the observed Cohen's dp, and the
population rho. All the scaling required are performed within the functions (and so
you do not provide degrees of freedom).This is henceforth not a generic lambda-second
distribution, but a lambda-second custom-tailored  for the problem of standardized mean
difference.
}
\examples{

dlsecond(0.25, 9, 0.26, 0.333) # 1.03753
plsecond(0.25, 9, 0.26, 0.333) # 0.494299
qlsecond(0.01, 9, 0.26, 0.333) # -0.6468003

}
\references{
\insertAllCited{}
}
