% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CoOL_functions.R
\name{CoOL_default}
\alias{CoOL_default}
\title{The default analysis for computational phase of CoOL}
\usage{
CoOL_default(
  data,
  sub_groups = 3,
  exclude_below = 0.01,
  input_parameter_reg = 0.001,
  hidden = 10,
  monitor = TRUE,
  epochs = 10000
)
}
\arguments{
\item{data}{A data.frame(cbind(outcome_data,exposure_data)).}

\item{sub_groups}{Define the number of expected sub-groups.}

\item{exclude_below}{Risk contributions below this value are not shown in the table.}

\item{input_parameter_reg}{The regularization of the input parameters.}

\item{hidden}{The number of synergy-functions.}

\item{monitor}{Whether monitoring plots will be shown in R.}

\item{epochs}{The maximum number of epochs.}
}
\value{
A series of plots across the full Causes of Outcome Learning approach.
}
\description{
The analysis and plots presented in the main paper. We recommend using View(CoOL_default) and View() on the many sub-functions to understand the steps and modify to your own research question. 3 sets of training will run with a learning rate of 1e-4 and a patience of 200 epochs, a learning rate of 1e-5 and a patience of 100 epochs, and a learning rate of 1e-6 and a patience of 50 epochs.
}
\examples{
# Not run
while (FALSE) {
#See the example under CoOL_0_working_example for a more detailed tutorial
library(CoOL)
data <- CoOL_0_working_example(n=10000)
CoOL_default(data)
}
}
\references{
Rieckmann, Dworzynski, Arras, Lapuschkin, Samek, Arah, Rod, Ekstrom. 2022. Causes of outcome learning: A causal inference-inspired machine learning approach to disentangling common combinations of potential causes of a health outcome. International Journal of Epidemiology <https://doi.org/10.1093/ije/dyac078>
}
