% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vecttor.R
\name{vecttor}
\alias{vecttor}
\title{Alr of a bacteria}
\usage{
vecttor(i, especie, Tt, EspecieMaxima)
}
\arguments{
\item{i}{Number. Position of the bacteria that we make the alr in the matrix \code{especie}. \code{i} must be different that \code{EspecieMaxima}.}

\item{especie}{Matrix that contains at row i the bacterial taxa of bacteria i at all time points. The bacteria placed in the last row of the matrix will be used as reference in the alr transformation and will be at the denominator of the balance.}

\item{Tt}{Number of time points available}

\item{EspecieMaxima}{Row in which the bacteria used as reference is in \code{especie}. This is the bacteria that is going to be at the denominator of the balance and the denominator of the alr transformation. As a result, in this function, \code{EspecieMaxima} must be equal to \code{E}}
}
\value{
Returns a vector with the alr transformation of the bacteria \code{i} at time points t=2,...,\code{Tt}.
}
\description{
Writtes a vector with the alr transformation of the bacteria \code{i} at time points t=2,...,\code{Tt}.
}
\examples{


set.seed(123)
especie=t(gtools::rdirichlet(10,c(1,3,1,2,4)))
Tt=10
EspecieMaxima=5
i=2

vecttor(i,especie,Tt,EspecieMaxima)


}
