% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Graphics.R
\name{Graphics}
\alias{Graphics}
\title{Plots the time series}
\usage{
Graphics(especie, names.especie, esperanza, Variance, Plot.Tipe, Detail)
}
\arguments{
\item{especie}{Matrix that contains at row i the bacterial taxa of bacteria i at all time points.}

\item{names.especie}{Vector with the names of the bacteria in the same order that are placed in the \code{especie} matrix.}

\item{esperanza}{Matrix that contains at row i the expected value of the bacterial taxa i at all time points. The bacteria must be placed in the same order than in \code{especie}}

\item{Variance}{Matrix that contains at row i the variance of the bacterial taxa i at all time points. The bacteria must be placed in the same order than in \code{especie}}

\item{Plot.Tipe}{Character. If \code{Plot.Tipe==Data} the function displays a graphic of the dataset, if \code{Plot.Tipe==DataExpected} the function displays a graphic of the data and the expected values, if \code{Plot.Tipe==All} the function displais a graphic woth the data, the expected values and the variance.If  \code{Plot.Tipe==Var} the function returns the boxplot of the variance at each time point and the variance of each bacteria. If  \code{Plot.Tipe==OnlyVar} the function returns the boxplots of the variance at each time points.}

\item{Detail}{Character. If \code{Detail==no} the graphic obtained when \code{Plot.Tipe==DataExpected} and \code{Plot.Tipe==All} will have the same y axis for all the taxa. If \code{Detail==yes} these functions will have different y axis.}
}
\value{
Returns the indicated plots.
}
\description{
Plots the time series
}
\examples{


names.especie=c("Bact1", "Bact2", "Bact3")
especie=cbind(c(0.5,0.3,0.2), c(0.6,0.3,0.1),c(0.4,0.1,0.5),c(0.4,0.1,0.5))
esperanza=especie[,c(1:3)]+0.1
Variance=matrix(c(runif(9,0.001,0.004)), 3,3)

Graphics(especie, names.especie, esperanza, Variance,"Data","no")
Graphics(especie, names.especie, esperanza, Variance,"DataExpected","no")
Graphics(especie, names.especie, esperanza, Variance,"All","no")
}
