#' Gut microbiome simulated dataset
#'
#' Simulated dataset with 5 microbial taxa and 10 time points. Following the scheme given by Faust et al (2018), we generated the interaction matrix using the algorithm proposed by Klemm and Eguíluz (2002), and we generated the initial abundances using the Poisson distribution. With these two tools, we simulated the data using the generalized Lotka-Volterra structure. We carried out the simulation using the R package seqtime (Faust et al, 2018). Focusing on technical details, to generate the interaction matrix we set the clique size at 4, the diagonal values at -1, the interaction connectance at 0.04, the positive edge percentage at 64%, and the maximal ab-solute off-diagonal interaction strength at 1.
#'
#'
#' @docType data
#' @keywords datasets
#' @name Simulated
#' @usage data(Simulated)
#' @format A data frame with 10 rows and 6 columns.
#' @references
#' \itemize{
#' \item K. Faust, F. Bauchinger, B. Laroche et al., “Signatures ofecological processes in microbial community time series”. Microbiome, vol. 6, no. 1, p. 120, 2018
#' \item K. Klemm and V. M. Eguíluz, “Growing scale-free networkswith small-world behavior”. Physical Review, vol. 65, no. 5,Article ID 057102, 2002.
#' }

"Simulated"


